<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingQuery StructType
 * @subpackage Structs
 */
class BookingQuery extends AbstractStructBase
{
    /**
     * The DetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DetailLevel;
    /**
     * The DataSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataSource;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingQuery
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The QueryParams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\QueryParamsElement
     */
    public $QueryParams;
    /**
     * Constructor method for BookingQuery
     * @uses BookingQuery::setDetailLevel()
     * @uses BookingQuery::setDataSource()
     * @uses BookingQuery::setXiRequest()
     * @uses BookingQuery::setAuthority()
     * @uses BookingQuery::setQueryParams()
     * @param string $detailLevel
     * @param string $dataSource
     * @param \Stuba\StructType\BookingQuery $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param \Stuba\StructType\QueryParamsElement $queryParams
     */
    public function __construct($detailLevel = null, $dataSource = null, \Stuba\StructType\BookingQuery $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, \Stuba\StructType\QueryParamsElement $queryParams = null)
    {
        $this
            ->setDetailLevel($detailLevel)
            ->setDataSource($dataSource)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setQueryParams($queryParams);
    }
    /**
     * Get DetailLevel value
     * @return string
     */
    public function getDetailLevel()
    {
        return $this->DetailLevel;
    }
    /**
     * Set DetailLevel value
     * @param string $detailLevel
     * @return \Stuba\StructType\BookingQuery
     */
    public function setDetailLevel($detailLevel = null)
    {
        $this->DetailLevel = $detailLevel;
        return $this;
    }
    /**
     * Get DataSource value
     * @return string
     */
    public function getDataSource()
    {
        return $this->DataSource;
    }
    /**
     * Set DataSource value
     * @param string $dataSource
     * @return \Stuba\StructType\BookingQuery
     */
    public function setDataSource($dataSource = null)
    {
        $this->DataSource = $dataSource;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\BookingQuery|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\BookingQuery $xiRequest
     * @return \Stuba\StructType\BookingQuery
     */
    public function setXiRequest(\Stuba\StructType\BookingQuery $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\BookingQuery
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get QueryParams value
     * @return \Stuba\StructType\QueryParamsElement|null
     */
    public function getQueryParams()
    {
        return $this->QueryParams;
    }
    /**
     * Set QueryParams value
     * @param \Stuba\StructType\QueryParamsElement $queryParams
     * @return \Stuba\StructType\BookingQuery
     */
    public function setQueryParams(\Stuba\StructType\QueryParamsElement $queryParams = null)
    {
        $this->QueryParams = $queryParams;
        return $this;
    }
}
