<?php

namespace Stuba\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EnumItemStatus EnumType
 * @subpackage Enumerations
 */
class EnumItemStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'confirmed'
     * @return string 'confirmed'
     */
    const VALUE_CONFIRMED = 'confirmed';
    /**
     * Constant for value 'onrequest'
     * @return string 'onrequest'
     */
    const VALUE_ONREQUEST = 'onrequest';
    /**
     * Constant for value 'cancelled'
     * @return string 'cancelled'
     */
    const VALUE_CANCELLED = 'cancelled';
    /**
     * Constant for value 'quoted'
     * @return string 'quoted'
     */
    const VALUE_QUOTED = 'quoted';
    /**
     * Return allowed values
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_ONREQUEST
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_QUOTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONFIRMED,
            self::VALUE_ONREQUEST,
            self::VALUE_CANCELLED,
            self::VALUE_QUOTED,
        );
    }
}
