<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegionElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfRegionElement extends AbstractStructArrayBase
{
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\RegionElement[]
     */
    public $Region;
    /**
     * Constructor method for ArrayOfRegionElement
     * @uses ArrayOfRegionElement::setRegion()
     * @param \Stuba\StructType\RegionElement[] $region
     */
    public function __construct(array $region = array())
    {
        $this
            ->setRegion($region);
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\RegionElement[]|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\RegionElement[] $region
     * @return \Stuba\ArrayType\ArrayOfRegionElement
     */
    public function setRegion(array $region = array())
    {
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Add item to Region value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\RegionElement $item
     * @return \Stuba\ArrayType\ArrayOfRegionElement
     */
    public function addToRegion(\Stuba\StructType\RegionElement $item)
    {
        $this->Region[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\RegionElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\RegionElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\RegionElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\RegionElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\RegionElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Region
     */
    public function getAttributeName()
    {
        return 'Region';
    }
}
