<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRefreshedQuote ArrayType
 * @subpackage Arrays
 */
class ArrayOfRefreshedQuote extends AbstractStructArrayBase
{
    /**
     * The RefreshedQuote
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\RefreshedQuote[]
     */
    public $RefreshedQuote;
    /**
     * Constructor method for ArrayOfRefreshedQuote
     * @uses ArrayOfRefreshedQuote::setRefreshedQuote()
     * @param \Stuba\StructType\RefreshedQuote[] $refreshedQuote
     */
    public function __construct(array $refreshedQuote = array())
    {
        $this
            ->setRefreshedQuote($refreshedQuote);
    }
    /**
     * Get RefreshedQuote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\RefreshedQuote[]|null
     */
    public function getRefreshedQuote()
    {
        return isset($this->RefreshedQuote) ? $this->RefreshedQuote : null;
    }
    /**
     * Set RefreshedQuote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\RefreshedQuote[] $refreshedQuote
     * @return \Stuba\ArrayType\ArrayOfRefreshedQuote
     */
    public function setRefreshedQuote(array $refreshedQuote = array())
    {
        if (is_null($refreshedQuote) || (is_array($refreshedQuote) && empty($refreshedQuote))) {
            unset($this->RefreshedQuote);
        } else {
            $this->RefreshedQuote = $refreshedQuote;
        }
        return $this;
    }
    /**
     * Add item to RefreshedQuote value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\RefreshedQuote $item
     * @return \Stuba\ArrayType\ArrayOfRefreshedQuote
     */
    public function addToRefreshedQuote(\Stuba\StructType\RefreshedQuote $item)
    {
        $this->RefreshedQuote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\RefreshedQuote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\RefreshedQuote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\RefreshedQuote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\RefreshedQuote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\RefreshedQuote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RefreshedQuote
     */
    public function getAttributeName()
    {
        return 'RefreshedQuote';
    }
}
