<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.stubademo.com/RXLStagingServices/ASMX/XmlService.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.stubademo.com/RXLStagingServices/ASMX/XmlService.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Stuba\ClassMap::get(),
);
/**
 * Samples for Availability ServiceType
 */
$availability = new \Stuba\ServiceType\Availability($options);
/**
 * Sample call for AvailabilitySearch operation/method
 */
if ($availability->AvailabilitySearch(new \Stuba\StructType\AvailabilitySearch()) !== false) {
    print_r($availability->getResult());
} else {
    print_r($availability->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \Stuba\ServiceType\Transfer($options);
/**
 * Sample call for TransferAvailabilitySearch operation/method
 */
if ($transfer->TransferAvailabilitySearch(new \Stuba\StructType\TransferAvailabilitySearch()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferEndPointSearch operation/method
 */
if ($transfer->TransferEndPointSearch(new \Stuba\StructType\TransferEndPointSearch()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Sample call for TransferRouteSearch operation/method
 */
if ($transfer->TransferRouteSearch(new \Stuba\StructType\TransferRouteSearch()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \Stuba\ServiceType\Refresh($options);
/**
 * Sample call for RefreshHotel operation/method
 */
if ($refresh->RefreshHotel(new \Stuba\StructType\RefreshHotel()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Booking ServiceType
 */
$booking = new \Stuba\ServiceType\Booking($options);
/**
 * Sample call for BookingCreate operation/method
 */
if ($booking->BookingCreate(new \Stuba\StructType\BookingCreate()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingQuery operation/method
 */
if ($booking->BookingQuery(new \Stuba\StructType\BookingQuery()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingHCNQuery operation/method
 */
if ($booking->BookingHCNQuery(new \Stuba\StructType\BookingHCNQuery()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Sample call for BookingCancel operation/method
 */
if ($booking->BookingCancel(new \Stuba\StructType\BookingCancel()) !== false) {
    print_r($booking->getResult());
} else {
    print_r($booking->getLastError());
}
/**
 * Samples for Customer ServiceType
 */
$customer = new \Stuba\ServiceType\Customer($options);
/**
 * Sample call for CustomerAmend operation/method
 */
if ($customer->CustomerAmend(new \Stuba\StructType\CustomerAmend()) !== false) {
    print_r($customer->getResult());
} else {
    print_r($customer->getLastError());
}
/**
 * Samples for Region ServiceType
 */
$region = new \Stuba\ServiceType\Region($options);
/**
 * Sample call for RegionSearch operation/method
 */
if ($region->RegionSearch(new \Stuba\StructType\RegionSearch()) !== false) {
    print_r($region->getResult());
} else {
    print_r($region->getLastError());
}
