<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriteriaElement StructType
 * @subpackage Structs
 */
class HotelSearchCriteriaElement extends AbstractStructBase
{
    /**
     * The MinStars
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinStars;
    /**
     * The MinPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinPrice;
    /**
     * The MaxPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxPrice;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The HotelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelType;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The HasAmenity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $HasAmenity;
    /**
     * Constructor method for HotelSearchCriteriaElement
     * @uses HotelSearchCriteriaElement::setMinStars()
     * @uses HotelSearchCriteriaElement::setMinPrice()
     * @uses HotelSearchCriteriaElement::setMaxPrice()
     * @uses HotelSearchCriteriaElement::setAvailabilityStatus()
     * @uses HotelSearchCriteriaElement::setHotelName()
     * @uses HotelSearchCriteriaElement::setHotelType()
     * @uses HotelSearchCriteriaElement::setSupplier()
     * @uses HotelSearchCriteriaElement::setHasAmenity()
     * @param int $minStars
     * @param float $minPrice
     * @param float $maxPrice
     * @param string $availabilityStatus
     * @param string $hotelName
     * @param string $hotelType
     * @param string $supplier
     * @param string[] $hasAmenity
     */
    public function __construct($minStars = null, $minPrice = null, $maxPrice = null, $availabilityStatus = null, $hotelName = null, $hotelType = null, $supplier = null, array $hasAmenity = array())
    {
        $this
            ->setMinStars($minStars)
            ->setMinPrice($minPrice)
            ->setMaxPrice($maxPrice)
            ->setAvailabilityStatus($availabilityStatus)
            ->setHotelName($hotelName)
            ->setHotelType($hotelType)
            ->setSupplier($supplier)
            ->setHasAmenity($hasAmenity);
    }
    /**
     * Get MinStars value
     * @return int
     */
    public function getMinStars()
    {
        return $this->MinStars;
    }
    /**
     * Set MinStars value
     * @param int $minStars
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setMinStars($minStars = null)
    {
        $this->MinStars = $minStars;
        return $this;
    }
    /**
     * Get MinPrice value
     * @return float
     */
    public function getMinPrice()
    {
        return $this->MinPrice;
    }
    /**
     * Set MinPrice value
     * @param float $minPrice
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setMinPrice($minPrice = null)
    {
        $this->MinPrice = $minPrice;
        return $this;
    }
    /**
     * Get MaxPrice value
     * @return float
     */
    public function getMaxPrice()
    {
        return $this->MaxPrice;
    }
    /**
     * Set MaxPrice value
     * @param float $maxPrice
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setMaxPrice($maxPrice = null)
    {
        $this->MaxPrice = $maxPrice;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @param string $availabilityStatus
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setHotelName($hotelName = null)
    {
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelType value
     * @return string|null
     */
    public function getHotelType()
    {
        return $this->HotelType;
    }
    /**
     * Set HotelType value
     * @param string $hotelType
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setHotelType($hotelType = null)
    {
        $this->HotelType = $hotelType;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get HasAmenity value
     * @return string[]|null
     */
    public function getHasAmenity()
    {
        return $this->HasAmenity;
    }
    /**
     * Set HasAmenity value
     * @param string[] $hasAmenity
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function setHasAmenity(array $hasAmenity = array())
    {
        $this->HasAmenity = $hasAmenity;
        return $this;
    }
    /**
     * Add item to HasAmenity value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Stuba\StructType\HotelSearchCriteriaElement
     */
    public function addToHasAmenity($item)
    {
        $this->HasAmenity[] = $item;
        return $this;
    }
}
