<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionSearch StructType
 * @subpackage Structs
 */
class RegionSearch extends AbstractStructBase
{
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegionId;
    /**
     * The ParentRegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParentRegionId;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\RegionSearch
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The RegionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegionName;
    /**
     * The ParentRegionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentRegionName;
    /**
     * The DepthChildren
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepthChildren;
    /**
     * The DepthParents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepthParents;
    /**
     * Constructor method for RegionSearch
     * @uses RegionSearch::setRegionId()
     * @uses RegionSearch::setParentRegionId()
     * @uses RegionSearch::setXiRequest()
     * @uses RegionSearch::setAuthority()
     * @uses RegionSearch::setRegionName()
     * @uses RegionSearch::setParentRegionName()
     * @uses RegionSearch::setDepthChildren()
     * @uses RegionSearch::setDepthParents()
     * @param int $regionId
     * @param int $parentRegionId
     * @param \Stuba\StructType\RegionSearch $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param string $regionName
     * @param string $parentRegionName
     * @param string $depthChildren
     * @param string $depthParents
     */
    public function __construct($regionId = null, $parentRegionId = null, \Stuba\StructType\RegionSearch $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, $regionName = null, $parentRegionName = null, $depthChildren = null, $depthParents = null)
    {
        $this
            ->setRegionId($regionId)
            ->setParentRegionId($parentRegionId)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setRegionName($regionName)
            ->setParentRegionName($parentRegionName)
            ->setDepthChildren($depthChildren)
            ->setDepthParents($depthParents);
    }
    /**
     * Get RegionId value
     * @return int
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param int $regionId
     * @return \Stuba\StructType\RegionSearch
     */
    public function setRegionId($regionId = null)
    {
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get ParentRegionId value
     * @return int
     */
    public function getParentRegionId()
    {
        return $this->ParentRegionId;
    }
    /**
     * Set ParentRegionId value
     * @param int $parentRegionId
     * @return \Stuba\StructType\RegionSearch
     */
    public function setParentRegionId($parentRegionId = null)
    {
        $this->ParentRegionId = $parentRegionId;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\RegionSearch|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\RegionSearch $xiRequest
     * @return \Stuba\StructType\RegionSearch
     */
    public function setXiRequest(\Stuba\StructType\RegionSearch $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\RegionSearch
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get RegionName value
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->RegionName;
    }
    /**
     * Set RegionName value
     * @param string $regionName
     * @return \Stuba\StructType\RegionSearch
     */
    public function setRegionName($regionName = null)
    {
        $this->RegionName = $regionName;
        return $this;
    }
    /**
     * Get ParentRegionName value
     * @return string|null
     */
    public function getParentRegionName()
    {
        return $this->ParentRegionName;
    }
    /**
     * Set ParentRegionName value
     * @param string $parentRegionName
     * @return \Stuba\StructType\RegionSearch
     */
    public function setParentRegionName($parentRegionName = null)
    {
        $this->ParentRegionName = $parentRegionName;
        return $this;
    }
    /**
     * Get DepthChildren value
     * @return string|null
     */
    public function getDepthChildren()
    {
        return $this->DepthChildren;
    }
    /**
     * Set DepthChildren value
     * @param string $depthChildren
     * @return \Stuba\StructType\RegionSearch
     */
    public function setDepthChildren($depthChildren = null)
    {
        $this->DepthChildren = $depthChildren;
        return $this;
    }
    /**
     * Get DepthParents value
     * @return string|null
     */
    public function getDepthParents()
    {
        return $this->DepthParents;
    }
    /**
     * Set DepthParents value
     * @param string $depthParents
     * @return \Stuba\StructType\RegionSearch
     */
    public function setDepthParents($depthParents = null)
    {
        $this->DepthParents = $depthParents;
        return $this;
    }
}
