<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartnerSellingPrice StructType
 * @subpackage Structs
 */
class PartnerSellingPrice extends AbstractStructBase
{
    /**
     * The PartnerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $PartnerId;
    /**
     * The PartnerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerName;
    /**
     * The SellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $SellingPrice;
    /**
     * Constructor method for PartnerSellingPrice
     * @uses PartnerSellingPrice::setPartnerId()
     * @uses PartnerSellingPrice::setPartnerName()
     * @uses PartnerSellingPrice::setSellingPrice()
     * @param int $partnerId
     * @param string $partnerName
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     */
    public function __construct($partnerId = null, $partnerName = null, \Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this
            ->setPartnerId($partnerId)
            ->setPartnerName($partnerName)
            ->setSellingPrice($sellingPrice);
    }
    /**
     * Get PartnerId value
     * @return int|null
     */
    public function getPartnerId()
    {
        return $this->PartnerId;
    }
    /**
     * Set PartnerId value
     * @param int $partnerId
     * @return \Stuba\StructType\PartnerSellingPrice
     */
    public function setPartnerId($partnerId = null)
    {
        $this->PartnerId = $partnerId;
        return $this;
    }
    /**
     * Get PartnerName value
     * @return string|null
     */
    public function getPartnerName()
    {
        return $this->PartnerName;
    }
    /**
     * Set PartnerName value
     * @param string $partnerName
     * @return \Stuba\StructType\PartnerSellingPrice
     */
    public function setPartnerName($partnerName = null)
    {
        $this->PartnerName = $partnerName;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @return \Stuba\StructType\PartnerSellingPrice
     */
    public function setSellingPrice(\Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
}
