<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAvailabilityRoomElement StructType
 * @subpackage Structs
 */
class HotelAvailabilityRoomElement extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $RoomType;
    /**
     * The MealType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $MealType;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $Price;
    /**
     * The SellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $SellingPrice;
    /**
     * The BuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $BuyingPrice;
    /**
     * The Night
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\NightElement[]
     */
    public $Night;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\ArrayOfChoice2
     */
    public $Guests;
    /**
     * The Confirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Confirmation;
    /**
     * The Extras
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfExtraElement
     */
    public $Extras;
    /**
     * The Upgrades
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfUpgradeElement
     */
    public $Upgrades;
    /**
     * The CanxFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfFeeElement
     */
    public $CanxFees;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfMessageElement
     */
    public $Messages;
    /**
     * The CancellationPolicyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancellationPolicyStatus;
    /**
     * The CanxFeeStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CanxFeeStartDate;
    /**
     * The CancelPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\CancelPolicyFromElement
     */
    public $CancelPolicy;
    /**
     * The supplier
     * @var string
     */
    public $supplier;
    /**
     * The conf
     * @var string
     */
    public $conf;
    /**
     * Constructor method for HotelAvailabilityRoomElement
     * @uses HotelAvailabilityRoomElement::setSupplier()
     * @uses HotelAvailabilityRoomElement::setRoomType()
     * @uses HotelAvailabilityRoomElement::setMealType()
     * @uses HotelAvailabilityRoomElement::setPrice()
     * @uses HotelAvailabilityRoomElement::setSellingPrice()
     * @uses HotelAvailabilityRoomElement::setBuyingPrice()
     * @uses HotelAvailabilityRoomElement::setNight()
     * @uses HotelAvailabilityRoomElement::setGuests()
     * @uses HotelAvailabilityRoomElement::setConfirmation()
     * @uses HotelAvailabilityRoomElement::setExtras()
     * @uses HotelAvailabilityRoomElement::setUpgrades()
     * @uses HotelAvailabilityRoomElement::setCanxFees()
     * @uses HotelAvailabilityRoomElement::setMessages()
     * @uses HotelAvailabilityRoomElement::setCancellationPolicyStatus()
     * @uses HotelAvailabilityRoomElement::setCanxFeeStartDate()
     * @uses HotelAvailabilityRoomElement::setCancelPolicy()
     * @uses HotelAvailabilityRoomElement::setSupplier_1()
     * @uses HotelAvailabilityRoomElement::setConf()
     * @param string $supplier
     * @param \Stuba\StructType\TextEnumPair $roomType
     * @param \Stuba\StructType\TextEnumPair $mealType
     * @param \Stuba\StructType\MoneyElement $price
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @param \Stuba\StructType\NightElement[] $night
     * @param \Stuba\StructType\ArrayOfChoice2 $guests
     * @param string $confirmation
     * @param \Stuba\ArrayType\ArrayOfExtraElement $extras
     * @param \Stuba\ArrayType\ArrayOfUpgradeElement $upgrades
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @param string $cancellationPolicyStatus
     * @param string $canxFeeStartDate
     * @param \Stuba\StructType\CancelPolicyFromElement $cancelPolicy
     * @param string $supplier
     * @param string $conf
     */
    public function __construct($supplier = null, \Stuba\StructType\TextEnumPair $roomType = null, \Stuba\StructType\TextEnumPair $mealType = null, \Stuba\StructType\MoneyElement $price = null, \Stuba\StructType\MoneyElement $sellingPrice = null, \Stuba\StructType\MoneyElement $buyingPrice = null, array $night = array(), \Stuba\StructType\ArrayOfChoice2 $guests = null, $confirmation = null, \Stuba\ArrayType\ArrayOfExtraElement $extras = null, \Stuba\ArrayType\ArrayOfUpgradeElement $upgrades = null, \Stuba\ArrayType\ArrayOfFeeElement $canxFees = null, \Stuba\ArrayType\ArrayOfMessageElement $messages = null, $cancellationPolicyStatus = null, $canxFeeStartDate = null, \Stuba\StructType\CancelPolicyFromElement $cancelPolicy = null, $supplier_1 = null, $conf = null)
    {
        $this
            ->setSupplier($supplier)
            ->setRoomType($roomType)
            ->setMealType($mealType)
            ->setPrice($price)
            ->setSellingPrice($sellingPrice)
            ->setBuyingPrice($buyingPrice)
            ->setNight($night)
            ->setGuests($guests)
            ->setConfirmation($confirmation)
            ->setExtras($extras)
            ->setUpgrades($upgrades)
            ->setCanxFees($canxFees)
            ->setMessages($messages)
            ->setCancellationPolicyStatus($cancellationPolicyStatus)
            ->setCanxFeeStartDate($canxFeeStartDate)
            ->setCancelPolicy($cancelPolicy)
            ->setSupplier_1($supplier_1)
            ->setConf($conf);
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get RoomType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param \Stuba\StructType\TextEnumPair $roomType
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setRoomType(\Stuba\StructType\TextEnumPair $roomType = null)
    {
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get MealType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getMealType()
    {
        return $this->MealType;
    }
    /**
     * Set MealType value
     * @param \Stuba\StructType\TextEnumPair $mealType
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setMealType(\Stuba\StructType\TextEnumPair $mealType = null)
    {
        $this->MealType = $mealType;
        return $this;
    }
    /**
     * Get Price value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \Stuba\StructType\MoneyElement $price
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setPrice(\Stuba\StructType\MoneyElement $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setSellingPrice(\Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
    /**
     * Get BuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getBuyingPrice()
    {
        return $this->BuyingPrice;
    }
    /**
     * Set BuyingPrice value
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setBuyingPrice(\Stuba\StructType\MoneyElement $buyingPrice = null)
    {
        $this->BuyingPrice = $buyingPrice;
        return $this;
    }
    /**
     * Get Night value
     * @return \Stuba\StructType\NightElement[]|null
     */
    public function getNight()
    {
        return $this->Night;
    }
    /**
     * Set Night value
     * @param \Stuba\StructType\NightElement[] $night
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setNight(array $night = array())
    {
        $this->Night = $night;
        return $this;
    }
    /**
     * Add item to Night value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\NightElement $item
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function addToNight(\Stuba\StructType\NightElement $item)
    {
        $this->Night[] = $item;
        return $this;
    }
    /**
     * Get Guests value
     * @return \Stuba\StructType\ArrayOfChoice2|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \Stuba\StructType\ArrayOfChoice2 $guests
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setGuests(\Stuba\StructType\ArrayOfChoice2 $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return string|null
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param string $confirmation
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setConfirmation($confirmation = null)
    {
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get Extras value
     * @return \Stuba\ArrayType\ArrayOfExtraElement|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \Stuba\ArrayType\ArrayOfExtraElement $extras
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setExtras(\Stuba\ArrayType\ArrayOfExtraElement $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Upgrades value
     * @return \Stuba\ArrayType\ArrayOfUpgradeElement|null
     */
    public function getUpgrades()
    {
        return $this->Upgrades;
    }
    /**
     * Set Upgrades value
     * @param \Stuba\ArrayType\ArrayOfUpgradeElement $upgrades
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setUpgrades(\Stuba\ArrayType\ArrayOfUpgradeElement $upgrades = null)
    {
        $this->Upgrades = $upgrades;
        return $this;
    }
    /**
     * Get CanxFees value
     * @return \Stuba\ArrayType\ArrayOfFeeElement|null
     */
    public function getCanxFees()
    {
        return $this->CanxFees;
    }
    /**
     * Set CanxFees value
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setCanxFees(\Stuba\ArrayType\ArrayOfFeeElement $canxFees = null)
    {
        $this->CanxFees = $canxFees;
        return $this;
    }
    /**
     * Get Messages value
     * @return \Stuba\ArrayType\ArrayOfMessageElement|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setMessages(\Stuba\ArrayType\ArrayOfMessageElement $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Get CancellationPolicyStatus value
     * @return string|null
     */
    public function getCancellationPolicyStatus()
    {
        return $this->CancellationPolicyStatus;
    }
    /**
     * Set CancellationPolicyStatus value
     * @param string $cancellationPolicyStatus
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setCancellationPolicyStatus($cancellationPolicyStatus = null)
    {
        $this->CancellationPolicyStatus = $cancellationPolicyStatus;
        return $this;
    }
    /**
     * Get CanxFeeStartDate value
     * @return string|null
     */
    public function getCanxFeeStartDate()
    {
        return $this->CanxFeeStartDate;
    }
    /**
     * Set CanxFeeStartDate value
     * @param string $canxFeeStartDate
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setCanxFeeStartDate($canxFeeStartDate = null)
    {
        $this->CanxFeeStartDate = $canxFeeStartDate;
        return $this;
    }
    /**
     * Get CancelPolicy value
     * @return \Stuba\StructType\CancelPolicyFromElement|null
     */
    public function getCancelPolicy()
    {
        return $this->CancelPolicy;
    }
    /**
     * Set CancelPolicy value
     * @param \Stuba\StructType\CancelPolicyFromElement $cancelPolicy
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setCancelPolicy(\Stuba\StructType\CancelPolicyFromElement $cancelPolicy = null)
    {
        $this->CancelPolicy = $cancelPolicy;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier_1()
    {
        return $this->supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setSupplier_1($supplier_1 = null)
    {
        $this->supplier = $supplier_1;
        return $this;
    }
    /**
     * Get conf value
     * @return string|null
     */
    public function getConf()
    {
        return $this->conf;
    }
    /**
     * Set conf value
     * @param string $conf
     * @return \Stuba\StructType\HotelAvailabilityRoomElement
     */
    public function setConf($conf = null)
    {
        $this->conf = $conf;
        return $this;
    }
}
