<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HCNElement StructType
 * @subpackage Structs
 */
class HCNElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The HotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HCNHotelBookingElement[]
     */
    public $HotelBooking;
    /**
     * Constructor method for HCNElement
     * @uses HCNElement::setId()
     * @uses HCNElement::setHotelBooking()
     * @param int $id
     * @param \Stuba\StructType\HCNHotelBookingElement[] $hotelBooking
     */
    public function __construct($id = null, array $hotelBooking = array())
    {
        $this
            ->setId($id)
            ->setHotelBooking($hotelBooking);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\HCNElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get HotelBooking value
     * @return \Stuba\StructType\HCNHotelBookingElement[]|null
     */
    public function getHotelBooking()
    {
        return $this->HotelBooking;
    }
    /**
     * Set HotelBooking value
     * @param \Stuba\StructType\HCNHotelBookingElement[] $hotelBooking
     * @return \Stuba\StructType\HCNElement
     */
    public function setHotelBooking(array $hotelBooking = array())
    {
        $this->HotelBooking = $hotelBooking;
        return $this;
    }
    /**
     * Add item to HotelBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HCNHotelBookingElement $item
     * @return \Stuba\StructType\HCNElement
     */
    public function addToHotelBooking(\Stuba\StructType\HCNHotelBookingElement $item)
    {
        $this->HotelBooking[] = $item;
        return $this;
    }
}
