<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferEndPointElement StructType
 * @subpackage Structs
 */
class TransferEndPointElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferEndPointRegionElement
     */
    public $Region;
    /**
     * The SupplierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferEndPointSupplierInfoElement[]
     */
    public $SupplierInfo;
    /**
     * Constructor method for TransferEndPointElement
     * @uses TransferEndPointElement::setId()
     * @uses TransferEndPointElement::setType()
     * @uses TransferEndPointElement::setName()
     * @uses TransferEndPointElement::setRegion()
     * @uses TransferEndPointElement::setSupplierInfo()
     * @param int $id
     * @param string $type
     * @param string $name
     * @param \Stuba\StructType\TransferEndPointRegionElement $region
     * @param \Stuba\StructType\TransferEndPointSupplierInfoElement[] $supplierInfo
     */
    public function __construct($id = null, $type = null, $name = null, \Stuba\StructType\TransferEndPointRegionElement $region = null, array $supplierInfo = array())
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setName($name)
            ->setRegion($region)
            ->setSupplierInfo($supplierInfo);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Region value
     * @return \Stuba\StructType\TransferEndPointRegionElement|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \Stuba\StructType\TransferEndPointRegionElement $region
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function setRegion(\Stuba\StructType\TransferEndPointRegionElement $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get SupplierInfo value
     * @return \Stuba\StructType\TransferEndPointSupplierInfoElement[]|null
     */
    public function getSupplierInfo()
    {
        return $this->SupplierInfo;
    }
    /**
     * Set SupplierInfo value
     * @param \Stuba\StructType\TransferEndPointSupplierInfoElement[] $supplierInfo
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function setSupplierInfo(array $supplierInfo = array())
    {
        $this->SupplierInfo = $supplierInfo;
        return $this;
    }
    /**
     * Add item to SupplierInfo value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\TransferEndPointSupplierInfoElement $item
     * @return \Stuba\StructType\TransferEndPointElement
     */
    public function addToSupplierInfo(\Stuba\StructType\TransferEndPointSupplierInfoElement $item)
    {
        $this->SupplierInfo[] = $item;
        return $this;
    }
}
