<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescriptionElement StructType
 * @subpackage Structs
 */
class DescriptionElement extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for DescriptionElement
     * @uses DescriptionElement::setLanguage()
     * @uses DescriptionElement::setType()
     * @uses DescriptionElement::setText()
     * @param string $language
     * @param string $type
     * @param string $text
     */
    public function __construct($language = null, $type = null, $text = null)
    {
        $this
            ->setLanguage($language)
            ->setType($type)
            ->setText($text);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Stuba\StructType\DescriptionElement
     */
    public function setLanguage($language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\DescriptionElement
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Stuba\StructType\DescriptionElement
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
}
