<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferBookingElement StructType
 * @subpackage Structs
 */
class TransferBookingElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The PickupPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferEndPoint
     */
    public $PickupPoint;
    /**
     * The DestinationPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferEndPoint
     */
    public $DestinationPoint;
    /**
     * The RouteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $RouteId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The OutboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OutboundDateTime;
    /**
     * The InboundDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InboundDateTime;
    /**
     * The TransferDirection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferDirection;
    /**
     * The VehicleCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $VehicleCount;
    /**
     * The VehicleType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VehicleType;
    /**
     * The SupplierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferSupplierInfo
     */
    public $SupplierInfo;
    /**
     * The VoucherInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TransferVoucherInfo
     */
    public $VoucherInfo;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDate;
    /**
     * The TotalSellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalSellingPrice;
    /**
     * The TotalBuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalBuyingPrice;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\ArrayOfChoice6
     */
    public $Guests;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfMessageElement
     */
    public $Messages;
    /**
     * The CanxFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfFeeElement
     */
    public $CanxFees;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingReferenceElement[]
     */
    public $Reference;
    /**
     * The RequiredBookingInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\RequiredBookingInformationElement
     */
    public $RequiredBookingInformation;
    /**
     * Constructor method for TransferBookingElement
     * @uses TransferBookingElement::setId()
     * @uses TransferBookingElement::setPickupPoint()
     * @uses TransferBookingElement::setDestinationPoint()
     * @uses TransferBookingElement::setRouteId()
     * @uses TransferBookingElement::setStatus()
     * @uses TransferBookingElement::setOutboundDateTime()
     * @uses TransferBookingElement::setInboundDateTime()
     * @uses TransferBookingElement::setTransferDirection()
     * @uses TransferBookingElement::setVehicleCount()
     * @uses TransferBookingElement::setVehicleType()
     * @uses TransferBookingElement::setSupplierInfo()
     * @uses TransferBookingElement::setVoucherInfo()
     * @uses TransferBookingElement::setCreationDate()
     * @uses TransferBookingElement::setTotalSellingPrice()
     * @uses TransferBookingElement::setTotalBuyingPrice()
     * @uses TransferBookingElement::setGuests()
     * @uses TransferBookingElement::setMessages()
     * @uses TransferBookingElement::setCanxFees()
     * @uses TransferBookingElement::setReference()
     * @uses TransferBookingElement::setRequiredBookingInformation()
     * @param int $id
     * @param \Stuba\StructType\TransferEndPoint $pickupPoint
     * @param \Stuba\StructType\TransferEndPoint $destinationPoint
     * @param int $routeId
     * @param string $status
     * @param string $outboundDateTime
     * @param string $inboundDateTime
     * @param string $transferDirection
     * @param int $vehicleCount
     * @param string $vehicleType
     * @param \Stuba\StructType\TransferSupplierInfo $supplierInfo
     * @param \Stuba\StructType\TransferVoucherInfo $voucherInfo
     * @param string $creationDate
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @param \Stuba\StructType\ArrayOfChoice6 $guests
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @param \Stuba\StructType\BookingReferenceElement[] $reference
     * @param \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation
     */
    public function __construct($id = null, \Stuba\StructType\TransferEndPoint $pickupPoint = null, \Stuba\StructType\TransferEndPoint $destinationPoint = null, $routeId = null, $status = null, $outboundDateTime = null, $inboundDateTime = null, $transferDirection = null, $vehicleCount = null, $vehicleType = null, \Stuba\StructType\TransferSupplierInfo $supplierInfo = null, \Stuba\StructType\TransferVoucherInfo $voucherInfo = null, $creationDate = null, \Stuba\StructType\MoneyElement $totalSellingPrice = null, \Stuba\StructType\MoneyElement $totalBuyingPrice = null, \Stuba\StructType\ArrayOfChoice6 $guests = null, \Stuba\ArrayType\ArrayOfMessageElement $messages = null, \Stuba\ArrayType\ArrayOfFeeElement $canxFees = null, array $reference = array(), \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation = null)
    {
        $this
            ->setId($id)
            ->setPickupPoint($pickupPoint)
            ->setDestinationPoint($destinationPoint)
            ->setRouteId($routeId)
            ->setStatus($status)
            ->setOutboundDateTime($outboundDateTime)
            ->setInboundDateTime($inboundDateTime)
            ->setTransferDirection($transferDirection)
            ->setVehicleCount($vehicleCount)
            ->setVehicleType($vehicleType)
            ->setSupplierInfo($supplierInfo)
            ->setVoucherInfo($voucherInfo)
            ->setCreationDate($creationDate)
            ->setTotalSellingPrice($totalSellingPrice)
            ->setTotalBuyingPrice($totalBuyingPrice)
            ->setGuests($guests)
            ->setMessages($messages)
            ->setCanxFees($canxFees)
            ->setReference($reference)
            ->setRequiredBookingInformation($requiredBookingInformation);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get PickupPoint value
     * @return \Stuba\StructType\TransferEndPoint|null
     */
    public function getPickupPoint()
    {
        return $this->PickupPoint;
    }
    /**
     * Set PickupPoint value
     * @param \Stuba\StructType\TransferEndPoint $pickupPoint
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setPickupPoint(\Stuba\StructType\TransferEndPoint $pickupPoint = null)
    {
        $this->PickupPoint = $pickupPoint;
        return $this;
    }
    /**
     * Get DestinationPoint value
     * @return \Stuba\StructType\TransferEndPoint|null
     */
    public function getDestinationPoint()
    {
        return $this->DestinationPoint;
    }
    /**
     * Set DestinationPoint value
     * @param \Stuba\StructType\TransferEndPoint $destinationPoint
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setDestinationPoint(\Stuba\StructType\TransferEndPoint $destinationPoint = null)
    {
        $this->DestinationPoint = $destinationPoint;
        return $this;
    }
    /**
     * Get RouteId value
     * @return int|null
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setRouteId($routeId = null)
    {
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get OutboundDateTime value
     * @return string|null
     */
    public function getOutboundDateTime()
    {
        return $this->OutboundDateTime;
    }
    /**
     * Set OutboundDateTime value
     * @param string $outboundDateTime
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setOutboundDateTime($outboundDateTime = null)
    {
        $this->OutboundDateTime = $outboundDateTime;
        return $this;
    }
    /**
     * Get InboundDateTime value
     * @return string|null
     */
    public function getInboundDateTime()
    {
        return $this->InboundDateTime;
    }
    /**
     * Set InboundDateTime value
     * @param string $inboundDateTime
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setInboundDateTime($inboundDateTime = null)
    {
        $this->InboundDateTime = $inboundDateTime;
        return $this;
    }
    /**
     * Get TransferDirection value
     * @return string|null
     */
    public function getTransferDirection()
    {
        return $this->TransferDirection;
    }
    /**
     * Set TransferDirection value
     * @param string $transferDirection
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setTransferDirection($transferDirection = null)
    {
        $this->TransferDirection = $transferDirection;
        return $this;
    }
    /**
     * Get VehicleCount value
     * @return int|null
     */
    public function getVehicleCount()
    {
        return $this->VehicleCount;
    }
    /**
     * Set VehicleCount value
     * @param int $vehicleCount
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setVehicleCount($vehicleCount = null)
    {
        $this->VehicleCount = $vehicleCount;
        return $this;
    }
    /**
     * Get VehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @param string $vehicleType
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setVehicleType($vehicleType = null)
    {
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Get SupplierInfo value
     * @return \Stuba\StructType\TransferSupplierInfo|null
     */
    public function getSupplierInfo()
    {
        return $this->SupplierInfo;
    }
    /**
     * Set SupplierInfo value
     * @param \Stuba\StructType\TransferSupplierInfo $supplierInfo
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setSupplierInfo(\Stuba\StructType\TransferSupplierInfo $supplierInfo = null)
    {
        $this->SupplierInfo = $supplierInfo;
        return $this;
    }
    /**
     * Get VoucherInfo value
     * @return \Stuba\StructType\TransferVoucherInfo|null
     */
    public function getVoucherInfo()
    {
        return $this->VoucherInfo;
    }
    /**
     * Set VoucherInfo value
     * @param \Stuba\StructType\TransferVoucherInfo $voucherInfo
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setVoucherInfo(\Stuba\StructType\TransferVoucherInfo $voucherInfo = null)
    {
        $this->VoucherInfo = $voucherInfo;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setCreationDate($creationDate = null)
    {
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get TotalSellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalSellingPrice()
    {
        return $this->TotalSellingPrice;
    }
    /**
     * Set TotalSellingPrice value
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setTotalSellingPrice(\Stuba\StructType\MoneyElement $totalSellingPrice = null)
    {
        $this->TotalSellingPrice = $totalSellingPrice;
        return $this;
    }
    /**
     * Get TotalBuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalBuyingPrice()
    {
        return $this->TotalBuyingPrice;
    }
    /**
     * Set TotalBuyingPrice value
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setTotalBuyingPrice(\Stuba\StructType\MoneyElement $totalBuyingPrice = null)
    {
        $this->TotalBuyingPrice = $totalBuyingPrice;
        return $this;
    }
    /**
     * Get Guests value
     * @return \Stuba\StructType\ArrayOfChoice6|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \Stuba\StructType\ArrayOfChoice6 $guests
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setGuests(\Stuba\StructType\ArrayOfChoice6 $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get Messages value
     * @return \Stuba\ArrayType\ArrayOfMessageElement|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setMessages(\Stuba\ArrayType\ArrayOfMessageElement $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Get CanxFees value
     * @return \Stuba\ArrayType\ArrayOfFeeElement|null
     */
    public function getCanxFees()
    {
        return $this->CanxFees;
    }
    /**
     * Set CanxFees value
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setCanxFees(\Stuba\ArrayType\ArrayOfFeeElement $canxFees = null)
    {
        $this->CanxFees = $canxFees;
        return $this;
    }
    /**
     * Get Reference value
     * @return \Stuba\StructType\BookingReferenceElement[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \Stuba\StructType\BookingReferenceElement[] $reference
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\BookingReferenceElement $item
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function addToReference(\Stuba\StructType\BookingReferenceElement $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get RequiredBookingInformation value
     * @return \Stuba\StructType\RequiredBookingInformationElement|null
     */
    public function getRequiredBookingInformation()
    {
        return $this->RequiredBookingInformation;
    }
    /**
     * Set RequiredBookingInformation value
     * @param \Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation
     * @return \Stuba\StructType\TransferBookingElement
     */
    public function setRequiredBookingInformation(\Stuba\StructType\RequiredBookingInformationElement $requiredBookingInformation = null)
    {
        $this->RequiredBookingInformation = $requiredBookingInformation;
        return $this;
    }
}
