<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseBase StructType
 * @subpackage Structs
 */
abstract class ResponseBase extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Warning;
    /**
     * The TestMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $TestMode;
    /**
     * Constructor method for ResponseBase
     * @uses ResponseBase::setCurrency()
     * @uses ResponseBase::setWarning()
     * @uses ResponseBase::setTestMode()
     * @param string $currency
     * @param string $warning
     * @param bool $testMode
     */
    public function __construct($currency = null, $warning = null, $testMode = null)
    {
        $this
            ->setCurrency($currency)
            ->setWarning($warning)
            ->setTestMode($testMode);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Stuba\StructType\ResponseBase
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Warning value
     * @return string|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @param string $warning
     * @return \Stuba\StructType\ResponseBase
     */
    public function setWarning($warning = null)
    {
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Get TestMode value
     * @return bool|null
     */
    public function getTestMode()
    {
        return $this->TestMode;
    }
    /**
     * Set TestMode value
     * @param bool $testMode
     * @return \Stuba\StructType\ResponseBase
     */
    public function setTestMode($testMode = null)
    {
        $this->TestMode = $testMode;
        return $this;
    }
}
