<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionElement StructType
 * @subpackage Structs
 */
class RegionElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Ranking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Ranking;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The IsSearchable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSearchable;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\RegionReferenceElement[]
     */
    public $Reference;
    /**
     * The Parent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\RegionElement
     */
    public $Parent;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfRegionElement
     */
    public $Children;
    /**
     * Constructor method for RegionElement
     * @uses RegionElement::setId()
     * @uses RegionElement::setRanking()
     * @uses RegionElement::setName()
     * @uses RegionElement::setType()
     * @uses RegionElement::setIsSearchable()
     * @uses RegionElement::setReference()
     * @uses RegionElement::setParent()
     * @uses RegionElement::setChildren()
     * @param int $id
     * @param int $ranking
     * @param string $name
     * @param string $type
     * @param bool $isSearchable
     * @param \Stuba\StructType\RegionReferenceElement[] $reference
     * @param \Stuba\StructType\RegionElement $parent
     * @param \Stuba\ArrayType\ArrayOfRegionElement $children
     */
    public function __construct($id = null, $ranking = null, $name = null, $type = null, $isSearchable = null, array $reference = array(), \Stuba\StructType\RegionElement $parent = null, \Stuba\ArrayType\ArrayOfRegionElement $children = null)
    {
        $this
            ->setId($id)
            ->setRanking($ranking)
            ->setName($name)
            ->setType($type)
            ->setIsSearchable($isSearchable)
            ->setReference($reference)
            ->setParent($parent)
            ->setChildren($children);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\RegionElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Ranking value
     * @return int
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param int $ranking
     * @return \Stuba\StructType\RegionElement
     */
    public function setRanking($ranking = null)
    {
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Stuba\StructType\RegionElement
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Stuba\StructType\RegionElement
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get IsSearchable value
     * @return bool|null
     */
    public function getIsSearchable()
    {
        return $this->IsSearchable;
    }
    /**
     * Set IsSearchable value
     * @param bool $isSearchable
     * @return \Stuba\StructType\RegionElement
     */
    public function setIsSearchable($isSearchable = null)
    {
        $this->IsSearchable = $isSearchable;
        return $this;
    }
    /**
     * Get Reference value
     * @return \Stuba\StructType\RegionReferenceElement[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \Stuba\StructType\RegionReferenceElement[] $reference
     * @return \Stuba\StructType\RegionElement
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\RegionReferenceElement $item
     * @return \Stuba\StructType\RegionElement
     */
    public function addToReference(\Stuba\StructType\RegionReferenceElement $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get Parent value
     * @return \Stuba\StructType\RegionElement|null
     */
    public function getParent()
    {
        return $this->Parent;
    }
    /**
     * Set Parent value
     * @param \Stuba\StructType\RegionElement $parent
     * @return \Stuba\StructType\RegionElement
     */
    public function setParent(\Stuba\StructType\RegionElement $parent = null)
    {
        $this->Parent = $parent;
        return $this;
    }
    /**
     * Get Children value
     * @return \Stuba\ArrayType\ArrayOfRegionElement|null
     */
    public function getChildren()
    {
        return $this->Children;
    }
    /**
     * Set Children value
     * @param \Stuba\ArrayType\ArrayOfRegionElement $children
     * @return \Stuba\StructType\RegionElement
     */
    public function setChildren(\Stuba\ArrayType\ArrayOfRegionElement $children = null)
    {
        $this->Children = $children;
        return $this;
    }
}
