<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefreshedQuote StructType
 * @subpackage Structs
 */
class RefreshedQuote extends AbstractStructBase
{
    /**
     * The quoteRefreshStatus
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $quoteRefreshStatus;
    /**
     * The Quote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingElement
     */
    public $Quote;
    /**
     * The originalQuoteId
     * @var string
     */
    public $originalQuoteId;
    /**
     * Constructor method for RefreshedQuote
     * @uses RefreshedQuote::setQuoteRefreshStatus()
     * @uses RefreshedQuote::setQuote()
     * @uses RefreshedQuote::setOriginalQuoteId()
     * @param string $quoteRefreshStatus
     * @param \Stuba\StructType\BookingElement $quote
     * @param string $originalQuoteId
     */
    public function __construct($quoteRefreshStatus = null, \Stuba\StructType\BookingElement $quote = null, $originalQuoteId = null)
    {
        $this
            ->setQuoteRefreshStatus($quoteRefreshStatus)
            ->setQuote($quote)
            ->setOriginalQuoteId($originalQuoteId);
    }
    /**
     * Get quoteRefreshStatus value
     * @return string
     */
    public function getQuoteRefreshStatus()
    {
        return $this->quoteRefreshStatus;
    }
    /**
     * Set quoteRefreshStatus value
     * @param string $quoteRefreshStatus
     * @return \Stuba\StructType\RefreshedQuote
     */
    public function setQuoteRefreshStatus($quoteRefreshStatus = null)
    {
        $this->quoteRefreshStatus = $quoteRefreshStatus;
        return $this;
    }
    /**
     * Get Quote value
     * @return \Stuba\StructType\BookingElement|null
     */
    public function getQuote()
    {
        return $this->Quote;
    }
    /**
     * Set Quote value
     * @param \Stuba\StructType\BookingElement $quote
     * @return \Stuba\StructType\RefreshedQuote
     */
    public function setQuote(\Stuba\StructType\BookingElement $quote = null)
    {
        $this->Quote = $quote;
        return $this;
    }
    /**
     * Get originalQuoteId value
     * @return string|null
     */
    public function getOriginalQuoteId()
    {
        return $this->originalQuoteId;
    }
    /**
     * Set originalQuoteId value
     * @param string $originalQuoteId
     * @return \Stuba\StructType\RefreshedQuote
     */
    public function setOriginalQuoteId($originalQuoteId = null)
    {
        $this->originalQuoteId = $originalQuoteId;
        return $this;
    }
}
