<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhotoElement StructType
 * @subpackage Structs
 */
class PhotoElement extends AbstractStructBase
{
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Height;
    /**
     * The Bytes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Bytes;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * The Caption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Caption;
    /**
     * The ThumbnailUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThumbnailUrl;
    /**
     * The ThumbnailWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ThumbnailWidth;
    /**
     * The ThumbnailHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ThumbnailHeight;
    /**
     * The ThumbnailBytes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ThumbnailBytes;
    /**
     * The PhotoType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhotoType;
    /**
     * Constructor method for PhotoElement
     * @uses PhotoElement::setWidth()
     * @uses PhotoElement::setHeight()
     * @uses PhotoElement::setBytes()
     * @uses PhotoElement::setUrl()
     * @uses PhotoElement::setCaption()
     * @uses PhotoElement::setThumbnailUrl()
     * @uses PhotoElement::setThumbnailWidth()
     * @uses PhotoElement::setThumbnailHeight()
     * @uses PhotoElement::setThumbnailBytes()
     * @uses PhotoElement::setPhotoType()
     * @param int $width
     * @param int $height
     * @param int $bytes
     * @param string $url
     * @param string $caption
     * @param string $thumbnailUrl
     * @param int $thumbnailWidth
     * @param int $thumbnailHeight
     * @param int $thumbnailBytes
     * @param string $photoType
     */
    public function __construct($width = null, $height = null, $bytes = null, $url = null, $caption = null, $thumbnailUrl = null, $thumbnailWidth = null, $thumbnailHeight = null, $thumbnailBytes = null, $photoType = null)
    {
        $this
            ->setWidth($width)
            ->setHeight($height)
            ->setBytes($bytes)
            ->setUrl($url)
            ->setCaption($caption)
            ->setThumbnailUrl($thumbnailUrl)
            ->setThumbnailWidth($thumbnailWidth)
            ->setThumbnailHeight($thumbnailHeight)
            ->setThumbnailBytes($thumbnailBytes)
            ->setPhotoType($photoType);
    }
    /**
     * Get Width value
     * @return int
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \Stuba\StructType\PhotoElement
     */
    public function setWidth($width = null)
    {
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \Stuba\StructType\PhotoElement
     */
    public function setHeight($height = null)
    {
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Bytes value
     * @return int
     */
    public function getBytes()
    {
        return $this->Bytes;
    }
    /**
     * Set Bytes value
     * @param int $bytes
     * @return \Stuba\StructType\PhotoElement
     */
    public function setBytes($bytes = null)
    {
        $this->Bytes = $bytes;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \Stuba\StructType\PhotoElement
     */
    public function setUrl($url = null)
    {
        $this->Url = $url;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \Stuba\StructType\PhotoElement
     */
    public function setCaption($caption = null)
    {
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ThumbnailUrl value
     * @return string|null
     */
    public function getThumbnailUrl()
    {
        return $this->ThumbnailUrl;
    }
    /**
     * Set ThumbnailUrl value
     * @param string $thumbnailUrl
     * @return \Stuba\StructType\PhotoElement
     */
    public function setThumbnailUrl($thumbnailUrl = null)
    {
        $this->ThumbnailUrl = $thumbnailUrl;
        return $this;
    }
    /**
     * Get ThumbnailWidth value
     * @return int|null
     */
    public function getThumbnailWidth()
    {
        return $this->ThumbnailWidth;
    }
    /**
     * Set ThumbnailWidth value
     * @param int $thumbnailWidth
     * @return \Stuba\StructType\PhotoElement
     */
    public function setThumbnailWidth($thumbnailWidth = null)
    {
        $this->ThumbnailWidth = $thumbnailWidth;
        return $this;
    }
    /**
     * Get ThumbnailHeight value
     * @return int|null
     */
    public function getThumbnailHeight()
    {
        return $this->ThumbnailHeight;
    }
    /**
     * Set ThumbnailHeight value
     * @param int $thumbnailHeight
     * @return \Stuba\StructType\PhotoElement
     */
    public function setThumbnailHeight($thumbnailHeight = null)
    {
        $this->ThumbnailHeight = $thumbnailHeight;
        return $this;
    }
    /**
     * Get ThumbnailBytes value
     * @return int|null
     */
    public function getThumbnailBytes()
    {
        return $this->ThumbnailBytes;
    }
    /**
     * Set ThumbnailBytes value
     * @param int $thumbnailBytes
     * @return \Stuba\StructType\PhotoElement
     */
    public function setThumbnailBytes($thumbnailBytes = null)
    {
        $this->ThumbnailBytes = $thumbnailBytes;
        return $this;
    }
    /**
     * Get PhotoType value
     * @return string|null
     */
    public function getPhotoType()
    {
        return $this->PhotoType;
    }
    /**
     * Set PhotoType value
     * @param string $photoType
     * @return \Stuba\StructType\PhotoElement
     */
    public function setPhotoType($photoType = null)
    {
        $this->PhotoType = $photoType;
        return $this;
    }
}
