<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelBookingElement StructType
 * @subpackage Structs
 */
class HotelBookingElement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The HotelId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HotelId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreationDate;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Nights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Nights;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The HotelName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelName;
    /**
     * The SupplierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingSupplierInfoElement
     */
    public $SupplierInfo;
    /**
     * The PartnerSellingPriceHierarchy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfPartnerSellingPrice
     */
    public $PartnerSellingPriceHierarchy;
    /**
     * The PriceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfPriceDetailElement
     */
    public $PriceDetails;
    /**
     * The TotalSellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalSellingPrice;
    /**
     * The TotalBuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalBuyingPrice;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelBookingRoomElement[]
     */
    public $Room;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingReferenceElement[]
     */
    public $Reference;
    /**
     * The VoucherInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\VoucherInfoElement
     */
    public $VoucherInfo;
    /**
     * The QuoteRefreshStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuoteRefreshStatus;
    /**
     * Constructor method for HotelBookingElement
     * @uses HotelBookingElement::setId()
     * @uses HotelBookingElement::setHotelId()
     * @uses HotelBookingElement::setCreationDate()
     * @uses HotelBookingElement::setArrivalDate()
     * @uses HotelBookingElement::setNights()
     * @uses HotelBookingElement::setStatus()
     * @uses HotelBookingElement::setHotelName()
     * @uses HotelBookingElement::setSupplierInfo()
     * @uses HotelBookingElement::setPartnerSellingPriceHierarchy()
     * @uses HotelBookingElement::setPriceDetails()
     * @uses HotelBookingElement::setTotalSellingPrice()
     * @uses HotelBookingElement::setTotalBuyingPrice()
     * @uses HotelBookingElement::setRoom()
     * @uses HotelBookingElement::setReference()
     * @uses HotelBookingElement::setVoucherInfo()
     * @uses HotelBookingElement::setQuoteRefreshStatus()
     * @param int $id
     * @param int $hotelId
     * @param string $creationDate
     * @param string $arrivalDate
     * @param int $nights
     * @param string $status
     * @param string $hotelName
     * @param \Stuba\StructType\BookingSupplierInfoElement $supplierInfo
     * @param \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy
     * @param \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @param \Stuba\StructType\HotelBookingRoomElement[] $room
     * @param \Stuba\StructType\BookingReferenceElement[] $reference
     * @param \Stuba\StructType\VoucherInfoElement $voucherInfo
     * @param string $quoteRefreshStatus
     */
    public function __construct($id = null, $hotelId = null, $creationDate = null, $arrivalDate = null, $nights = null, $status = null, $hotelName = null, \Stuba\StructType\BookingSupplierInfoElement $supplierInfo = null, \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy = null, \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails = null, \Stuba\StructType\MoneyElement $totalSellingPrice = null, \Stuba\StructType\MoneyElement $totalBuyingPrice = null, array $room = array(), array $reference = array(), \Stuba\StructType\VoucherInfoElement $voucherInfo = null, $quoteRefreshStatus = null)
    {
        $this
            ->setId($id)
            ->setHotelId($hotelId)
            ->setCreationDate($creationDate)
            ->setArrivalDate($arrivalDate)
            ->setNights($nights)
            ->setStatus($status)
            ->setHotelName($hotelName)
            ->setSupplierInfo($supplierInfo)
            ->setPartnerSellingPriceHierarchy($partnerSellingPriceHierarchy)
            ->setPriceDetails($priceDetails)
            ->setTotalSellingPrice($totalSellingPrice)
            ->setTotalBuyingPrice($totalBuyingPrice)
            ->setRoom($room)
            ->setReference($reference)
            ->setVoucherInfo($voucherInfo)
            ->setQuoteRefreshStatus($quoteRefreshStatus);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get HotelId value
     * @return int
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param int $hotelId
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setHotelId($hotelId = null)
    {
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get CreationDate value
     * @return string
     */
    public function getCreationDate()
    {
        return $this->CreationDate;
    }
    /**
     * Set CreationDate value
     * @param string $creationDate
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setCreationDate($creationDate = null)
    {
        $this->CreationDate = $creationDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setArrivalDate($arrivalDate = null)
    {
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Nights value
     * @return int
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setNights($nights = null)
    {
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setHotelName($hotelName = null)
    {
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get SupplierInfo value
     * @return \Stuba\StructType\BookingSupplierInfoElement|null
     */
    public function getSupplierInfo()
    {
        return $this->SupplierInfo;
    }
    /**
     * Set SupplierInfo value
     * @param \Stuba\StructType\BookingSupplierInfoElement $supplierInfo
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setSupplierInfo(\Stuba\StructType\BookingSupplierInfoElement $supplierInfo = null)
    {
        $this->SupplierInfo = $supplierInfo;
        return $this;
    }
    /**
     * Get PartnerSellingPriceHierarchy value
     * @return \Stuba\ArrayType\ArrayOfPartnerSellingPrice|null
     */
    public function getPartnerSellingPriceHierarchy()
    {
        return $this->PartnerSellingPriceHierarchy;
    }
    /**
     * Set PartnerSellingPriceHierarchy value
     * @param \Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setPartnerSellingPriceHierarchy(\Stuba\ArrayType\ArrayOfPartnerSellingPrice $partnerSellingPriceHierarchy = null)
    {
        $this->PartnerSellingPriceHierarchy = $partnerSellingPriceHierarchy;
        return $this;
    }
    /**
     * Get PriceDetails value
     * @return \Stuba\ArrayType\ArrayOfPriceDetailElement|null
     */
    public function getPriceDetails()
    {
        return $this->PriceDetails;
    }
    /**
     * Set PriceDetails value
     * @param \Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setPriceDetails(\Stuba\ArrayType\ArrayOfPriceDetailElement $priceDetails = null)
    {
        $this->PriceDetails = $priceDetails;
        return $this;
    }
    /**
     * Get TotalSellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalSellingPrice()
    {
        return $this->TotalSellingPrice;
    }
    /**
     * Set TotalSellingPrice value
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setTotalSellingPrice(\Stuba\StructType\MoneyElement $totalSellingPrice = null)
    {
        $this->TotalSellingPrice = $totalSellingPrice;
        return $this;
    }
    /**
     * Get TotalBuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalBuyingPrice()
    {
        return $this->TotalBuyingPrice;
    }
    /**
     * Set TotalBuyingPrice value
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setTotalBuyingPrice(\Stuba\StructType\MoneyElement $totalBuyingPrice = null)
    {
        $this->TotalBuyingPrice = $totalBuyingPrice;
        return $this;
    }
    /**
     * Get Room value
     * @return \Stuba\StructType\HotelBookingRoomElement[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \Stuba\StructType\HotelBookingRoomElement[] $room
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setRoom(array $room = array())
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HotelBookingRoomElement $item
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function addToRoom(\Stuba\StructType\HotelBookingRoomElement $item)
    {
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get Reference value
     * @return \Stuba\StructType\BookingReferenceElement[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param \Stuba\StructType\BookingReferenceElement[] $reference
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setReference(array $reference = array())
    {
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\BookingReferenceElement $item
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function addToReference(\Stuba\StructType\BookingReferenceElement $item)
    {
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Get VoucherInfo value
     * @return \Stuba\StructType\VoucherInfoElement|null
     */
    public function getVoucherInfo()
    {
        return $this->VoucherInfo;
    }
    /**
     * Set VoucherInfo value
     * @param \Stuba\StructType\VoucherInfoElement $voucherInfo
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setVoucherInfo(\Stuba\StructType\VoucherInfoElement $voucherInfo = null)
    {
        $this->VoucherInfo = $voucherInfo;
        return $this;
    }
    /**
     * Get QuoteRefreshStatus value
     * @return string|null
     */
    public function getQuoteRefreshStatus()
    {
        return $this->QuoteRefreshStatus;
    }
    /**
     * Set QuoteRefreshStatus value
     * @param string $quoteRefreshStatus
     * @return \Stuba\StructType\HotelBookingElement
     */
    public function setQuoteRefreshStatus($quoteRefreshStatus = null)
    {
        $this->QuoteRefreshStatus = $quoteRefreshStatus;
        return $this;
    }
}
