<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPolicyElement StructType
 * @subpackage Structs
 */
class CancelPolicyElement extends AbstractStructBase
{
    /**
     * The DaysInAdvance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysInAdvance;
    /**
     * The NightsToPay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NightsToPay;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Percentage;
    /**
     * The FixedFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $FixedFee;
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $Cost;
    /**
     * Constructor method for CancelPolicyElement
     * @uses CancelPolicyElement::setDaysInAdvance()
     * @uses CancelPolicyElement::setNightsToPay()
     * @uses CancelPolicyElement::setPercentage()
     * @uses CancelPolicyElement::setFixedFee()
     * @uses CancelPolicyElement::setCost()
     * @param int $daysInAdvance
     * @param int $nightsToPay
     * @param int $percentage
     * @param \Stuba\StructType\MoneyElement $fixedFee
     * @param \Stuba\StructType\MoneyElement $cost
     */
    public function __construct($daysInAdvance = null, $nightsToPay = null, $percentage = null, \Stuba\StructType\MoneyElement $fixedFee = null, \Stuba\StructType\MoneyElement $cost = null)
    {
        $this
            ->setDaysInAdvance($daysInAdvance)
            ->setNightsToPay($nightsToPay)
            ->setPercentage($percentage)
            ->setFixedFee($fixedFee)
            ->setCost($cost);
    }
    /**
     * Get DaysInAdvance value
     * @return int
     */
    public function getDaysInAdvance()
    {
        return $this->DaysInAdvance;
    }
    /**
     * Set DaysInAdvance value
     * @param int $daysInAdvance
     * @return \Stuba\StructType\CancelPolicyElement
     */
    public function setDaysInAdvance($daysInAdvance = null)
    {
        $this->DaysInAdvance = $daysInAdvance;
        return $this;
    }
    /**
     * Get NightsToPay value
     * @return int
     */
    public function getNightsToPay()
    {
        return $this->NightsToPay;
    }
    /**
     * Set NightsToPay value
     * @param int $nightsToPay
     * @return \Stuba\StructType\CancelPolicyElement
     */
    public function setNightsToPay($nightsToPay = null)
    {
        $this->NightsToPay = $nightsToPay;
        return $this;
    }
    /**
     * Get Percentage value
     * @return int
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param int $percentage
     * @return \Stuba\StructType\CancelPolicyElement
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get FixedFee value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getFixedFee()
    {
        return $this->FixedFee;
    }
    /**
     * Set FixedFee value
     * @param \Stuba\StructType\MoneyElement $fixedFee
     * @return \Stuba\StructType\CancelPolicyElement
     */
    public function setFixedFee(\Stuba\StructType\MoneyElement $fixedFee = null)
    {
        $this->FixedFee = $fixedFee;
        return $this;
    }
    /**
     * Get Cost value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param \Stuba\StructType\MoneyElement $cost
     * @return \Stuba\StructType\CancelPolicyElement
     */
    public function setCost(\Stuba\StructType\MoneyElement $cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
}
