<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingSupplierInfoElement StructType
 * @subpackage Structs
 */
class BookingSupplierInfoElement extends AbstractStructBase
{
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SupplierId;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The HotelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HotelCode;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingRef;
    /**
     * The ItemRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemRef;
    /**
     * The IsOffContract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsOffContract;
    /**
     * Constructor method for BookingSupplierInfoElement
     * @uses BookingSupplierInfoElement::setSupplierId()
     * @uses BookingSupplierInfoElement::setSupplier()
     * @uses BookingSupplierInfoElement::setHotelCode()
     * @uses BookingSupplierInfoElement::setBookingRef()
     * @uses BookingSupplierInfoElement::setItemRef()
     * @uses BookingSupplierInfoElement::setIsOffContract()
     * @param int $supplierId
     * @param string $supplier
     * @param string $hotelCode
     * @param string $bookingRef
     * @param string $itemRef
     * @param bool $isOffContract
     */
    public function __construct($supplierId = null, $supplier = null, $hotelCode = null, $bookingRef = null, $itemRef = null, $isOffContract = null)
    {
        $this
            ->setSupplierId($supplierId)
            ->setSupplier($supplier)
            ->setHotelCode($hotelCode)
            ->setBookingRef($bookingRef)
            ->setItemRef($itemRef)
            ->setIsOffContract($isOffContract);
    }
    /**
     * Get SupplierId value
     * @return int|null
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param int $supplierId
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setSupplierId($supplierId = null)
    {
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setHotelCode($hotelCode = null)
    {
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return string|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * Set BookingRef value
     * @param string $bookingRef
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setBookingRef($bookingRef = null)
    {
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Get ItemRef value
     * @return string|null
     */
    public function getItemRef()
    {
        return $this->ItemRef;
    }
    /**
     * Set ItemRef value
     * @param string $itemRef
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setItemRef($itemRef = null)
    {
        $this->ItemRef = $itemRef;
        return $this;
    }
    /**
     * Get IsOffContract value
     * @return bool|null
     */
    public function getIsOffContract()
    {
        return $this->IsOffContract;
    }
    /**
     * Set IsOffContract value
     * @param bool $isOffContract
     * @return \Stuba\StructType\BookingSupplierInfoElement
     */
    public function setIsOffContract($isOffContract = null)
    {
        $this->IsOffContract = $isOffContract;
        return $this;
    }
}
