<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrayOfChoice2 StructType
 * @subpackage Structs
 */
class ArrayOfChoice2 extends AbstractStructBase
{
    /**
     * The Child
     * Meta information extracted from the WSDL
     * - choice: Child | Adult | Guest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Stuba\StructType\ChildElement
     */
    public $Child;
    /**
     * The Adult
     * Meta information extracted from the WSDL
     * - choice: Child | Adult | Guest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Stuba\StructType\AdultElement
     */
    public $Adult;
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - choice: Child | Adult | Guest
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Stuba\StructType\GuestElement
     */
    public $Guest;
    /**
     * Constructor method for ArrayOfChoice2
     * @uses ArrayOfChoice2::setChild()
     * @uses ArrayOfChoice2::setAdult()
     * @uses ArrayOfChoice2::setGuest()
     * @param \Stuba\StructType\ChildElement $child
     * @param \Stuba\StructType\AdultElement $adult
     * @param \Stuba\StructType\GuestElement $guest
     */
    public function __construct(\Stuba\StructType\ChildElement $child = null, \Stuba\StructType\AdultElement $adult = null, \Stuba\StructType\GuestElement $guest = null)
    {
        $this
            ->setChild($child)
            ->setAdult($adult)
            ->setGuest($guest);
    }
    /**
     * Get Child value
     * @return \Stuba\StructType\ChildElement
     */
    public function getChild()
    {
        return isset($this->Child) ? $this->Child : null;
    }
    /**
     * Set Child value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Stuba\StructType\ChildElement $child
     * @return \Stuba\StructType\ArrayOfChoice2
     */
    public function setChild(\Stuba\StructType\ChildElement $child = null)
    {
        if (is_null($child) || (is_array($child) && empty($child))) {
            unset($this->Child);
        } else {
            $this->Child = $child;
        }
        return $this;
    }
    /**
     * Get Adult value
     * @return \Stuba\StructType\AdultElement
     */
    public function getAdult()
    {
        return isset($this->Adult) ? $this->Adult : null;
    }
    /**
     * Set Adult value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Stuba\StructType\AdultElement $adult
     * @return \Stuba\StructType\ArrayOfChoice2
     */
    public function setAdult(\Stuba\StructType\AdultElement $adult = null)
    {
        if (is_null($adult) || (is_array($adult) && empty($adult))) {
            unset($this->Adult);
        } else {
            $this->Adult = $adult;
        }
        return $this;
    }
    /**
     * Get Guest value
     * @return \Stuba\StructType\GuestElement
     */
    public function getGuest()
    {
        return isset($this->Guest) ? $this->Guest : null;
    }
    /**
     * Set Guest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \Stuba\StructType\GuestElement $guest
     * @return \Stuba\StructType\ArrayOfChoice2
     */
    public function setGuest(\Stuba\StructType\GuestElement $guest = null)
    {
        if (is_null($guest) || (is_array($guest) && empty($guest))) {
            unset($this->Guest);
        } else {
            $this->Guest = $guest;
        }
        return $this;
    }
}
