<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Region ServiceType
 * @subpackage Services
 */
class Region extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegionSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\RegionSearch $parameters
     * @return \Stuba\StructType\RegionSearchResponse|bool
     */
    public function RegionSearch(\Stuba\StructType\RegionSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegionSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\RegionSearchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
