<?php

namespace Stuba\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EnumStatus EnumType
 * @subpackage Enumerations
 */
class EnumStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'confirmed'
     * @return string 'confirmed'
     */
    const VALUE_CONFIRMED = 'confirmed';
    /**
     * Constant for value 'allonrequest'
     * @return string 'allonrequest'
     */
    const VALUE_ALLONREQUEST = 'allonrequest';
    /**
     * Constant for value 'someonrequest'
     * @return string 'someonrequest'
     */
    const VALUE_SOMEONREQUEST = 'someonrequest';
    /**
     * Constant for value 'cancelled'
     * @return string 'cancelled'
     */
    const VALUE_CANCELLED = 'cancelled';
    /**
     * Constant for value 'quoted'
     * @return string 'quoted'
     */
    const VALUE_QUOTED = 'quoted';
    /**
     * Constant for value 'unavailable'
     * @return string 'unavailable'
     */
    const VALUE_UNAVAILABLE = 'unavailable';
    /**
     * Return allowed values
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_ALLONREQUEST
     * @uses self::VALUE_SOMEONREQUEST
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_QUOTED
     * @uses self::VALUE_UNAVAILABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONFIRMED,
            self::VALUE_ALLONREQUEST,
            self::VALUE_SOMEONREQUEST,
            self::VALUE_CANCELLED,
            self::VALUE_QUOTED,
            self::VALUE_UNAVAILABLE,
        );
    }
}
