<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoneyElement StructType
 * @subpackage Structs
 */
class MoneyElement extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Estimated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Estimated;
    /**
     * The Converted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Converted;
    /**
     * The cur
     * @var string
     */
    public $cur;
    /**
     * The amt
     * @var float
     */
    public $amt;
    /**
     * The est
     * @var bool
     */
    public $est;
    /**
     * The conv
     * @var bool
     */
    public $conv;
    /**
     * Constructor method for MoneyElement
     * @uses MoneyElement::setCurrency()
     * @uses MoneyElement::setAmount()
     * @uses MoneyElement::setEstimated()
     * @uses MoneyElement::setConverted()
     * @uses MoneyElement::setCur()
     * @uses MoneyElement::setAmt()
     * @uses MoneyElement::setEst()
     * @uses MoneyElement::setConv()
     * @param string $currency
     * @param float $amount
     * @param bool $estimated
     * @param bool $converted
     * @param string $cur
     * @param float $amt
     * @param bool $est
     * @param bool $conv
     */
    public function __construct($currency = null, $amount = null, $estimated = null, $converted = null, $cur = null, $amt = null, $est = null, $conv = null)
    {
        $this
            ->setCurrency($currency)
            ->setAmount($amount)
            ->setEstimated($estimated)
            ->setConverted($converted)
            ->setCur($cur)
            ->setAmt($amt)
            ->setEst($est)
            ->setConv($conv);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Stuba\StructType\MoneyElement
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Stuba\StructType\MoneyElement
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Estimated value
     * @return bool|null
     */
    public function getEstimated()
    {
        return $this->Estimated;
    }
    /**
     * Set Estimated value
     * @param bool $estimated
     * @return \Stuba\StructType\MoneyElement
     */
    public function setEstimated($estimated = null)
    {
        $this->Estimated = $estimated;
        return $this;
    }
    /**
     * Get Converted value
     * @return bool|null
     */
    public function getConverted()
    {
        return $this->Converted;
    }
    /**
     * Set Converted value
     * @param bool $converted
     * @return \Stuba\StructType\MoneyElement
     */
    public function setConverted($converted = null)
    {
        $this->Converted = $converted;
        return $this;
    }
    /**
     * Get cur value
     * @return string|null
     */
    public function getCur()
    {
        return $this->cur;
    }
    /**
     * Set cur value
     * @param string $cur
     * @return \Stuba\StructType\MoneyElement
     */
    public function setCur($cur = null)
    {
        $this->cur = $cur;
        return $this;
    }
    /**
     * Get amt value
     * @return float|null
     */
    public function getAmt()
    {
        return $this->amt;
    }
    /**
     * Set amt value
     * @param float $amt
     * @return \Stuba\StructType\MoneyElement
     */
    public function setAmt($amt = null)
    {
        $this->amt = $amt;
        return $this;
    }
    /**
     * Get est value
     * @return bool|null
     */
    public function getEst()
    {
        return $this->est;
    }
    /**
     * Set est value
     * @param bool $est
     * @return \Stuba\StructType\MoneyElement
     */
    public function setEst($est = null)
    {
        $this->est = $est;
        return $this;
    }
    /**
     * Get conv value
     * @return bool|null
     */
    public function getConv()
    {
        return $this->conv;
    }
    /**
     * Set conv value
     * @param bool $conv
     * @return \Stuba\StructType\MoneyElement
     */
    public function setConv($conv = null)
    {
        $this->conv = $conv;
        return $this;
    }
}
