<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingHCNResult StructType
 * @subpackage Structs
 */
class BookingHCNResult extends ResponseBase
{
    /**
     * The Booking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HCNElement[]
     */
    public $Booking;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for BookingHCNResult
     * @uses BookingHCNResult::setBooking()
     * @uses BookingHCNResult::setMessage()
     * @param \Stuba\StructType\HCNElement[] $booking
     * @param string $message
     */
    public function __construct(array $booking = array(), $message = null)
    {
        $this
            ->setBooking($booking)
            ->setMessage($message);
    }
    /**
     * Get Booking value
     * @return \Stuba\StructType\HCNElement[]|null
     */
    public function getBooking()
    {
        return $this->Booking;
    }
    /**
     * Set Booking value
     * @param \Stuba\StructType\HCNElement[] $booking
     * @return \Stuba\StructType\BookingHCNResult
     */
    public function setBooking(array $booking = array())
    {
        $this->Booking = $booking;
        return $this;
    }
    /**
     * Add item to Booking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HCNElement $item
     * @return \Stuba\StructType\BookingHCNResult
     */
    public function addToBooking(\Stuba\StructType\HCNElement $item)
    {
        $this->Booking[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Stuba\StructType\BookingHCNResult
     */
    public function setMessage($message = null)
    {
        $this->Message = $message;
        return $this;
    }
}
