<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Booking ServiceType
 * @subpackage Services
 */
class Booking extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BookingCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\BookingCreate $parameters
     * @return \Stuba\StructType\BookingCreateResponse|bool
     */
    public function BookingCreate(\Stuba\StructType\BookingCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookingQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\BookingQuery $parameters
     * @return \Stuba\StructType\BookingQueryResponse|bool
     */
    public function BookingQuery(\Stuba\StructType\BookingQuery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookingHCNQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\BookingHCNQuery $parameters
     * @return \Stuba\StructType\BookingHCNQueryResponse|bool
     */
    public function BookingHCNQuery(\Stuba\StructType\BookingHCNQuery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingHCNQuery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BookingCancel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\BookingCancel $parameters
     * @return \Stuba\StructType\BookingCancelResponse|bool
     */
    public function BookingCancel(\Stuba\StructType\BookingCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\BookingCancelResponse|\Stuba\StructType\BookingCreateResponse|\Stuba\StructType\BookingHCNQueryResponse|\Stuba\StructType\BookingQueryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
