<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NightCostElement StructType
 * @subpackage Structs
 */
class NightCostElement extends AbstractStructBase
{
    /**
     * The Night
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Night;
    /**
     * The BuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $BuyingPrice;
    /**
     * The SellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $SellingPrice;
    /**
     * Constructor method for NightCostElement
     * @uses NightCostElement::setNight()
     * @uses NightCostElement::setBuyingPrice()
     * @uses NightCostElement::setSellingPrice()
     * @param int $night
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     */
    public function __construct($night = null, \Stuba\StructType\MoneyElement $buyingPrice = null, \Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this
            ->setNight($night)
            ->setBuyingPrice($buyingPrice)
            ->setSellingPrice($sellingPrice);
    }
    /**
     * Get Night value
     * @return int
     */
    public function getNight()
    {
        return $this->Night;
    }
    /**
     * Set Night value
     * @param int $night
     * @return \Stuba\StructType\NightCostElement
     */
    public function setNight($night = null)
    {
        $this->Night = $night;
        return $this;
    }
    /**
     * Get BuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getBuyingPrice()
    {
        return $this->BuyingPrice;
    }
    /**
     * Set BuyingPrice value
     * @param \Stuba\StructType\MoneyElement $buyingPrice
     * @return \Stuba\StructType\NightCostElement
     */
    public function setBuyingPrice(\Stuba\StructType\MoneyElement $buyingPrice = null)
    {
        $this->BuyingPrice = $buyingPrice;
        return $this;
    }
    /**
     * Get SellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getSellingPrice()
    {
        return $this->SellingPrice;
    }
    /**
     * Set SellingPrice value
     * @param \Stuba\StructType\MoneyElement $sellingPrice
     * @return \Stuba\StructType\NightCostElement
     */
    public function setSellingPrice(\Stuba\StructType\MoneyElement $sellingPrice = null)
    {
        $this->SellingPrice = $sellingPrice;
        return $this;
    }
}
