<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSupplierInfoElement StructType
 * @subpackage Structs
 */
class HotelSupplierInfoElement extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierCode;
    /**
     * Constructor method for HotelSupplierInfoElement
     * @uses HotelSupplierInfoElement::setSupplier()
     * @uses HotelSupplierInfoElement::setSupplierCode()
     * @param string $supplier
     * @param string $supplierCode
     */
    public function __construct($supplier = null, $supplierCode = null)
    {
        $this
            ->setSupplier($supplier)
            ->setSupplierCode($supplierCode);
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\HotelSupplierInfoElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \Stuba\StructType\HotelSupplierInfoElement
     */
    public function setSupplierCode($supplierCode = null)
    {
        $this->SupplierCode = $supplierCode;
        return $this;
    }
}
