<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HCNHotelBookingElement StructType
 * @subpackage Structs
 */
class HCNHotelBookingElement extends AbstractStructBase
{
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Nights
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Nights;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\HCNHotelBookingRoomElement[]
     */
    public $Room;
    /**
     * The HCN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HCN;
    /**
     * Constructor method for HCNHotelBookingElement
     * @uses HCNHotelBookingElement::setArrivalDate()
     * @uses HCNHotelBookingElement::setNights()
     * @uses HCNHotelBookingElement::setStatus()
     * @uses HCNHotelBookingElement::setRoom()
     * @uses HCNHotelBookingElement::setHCN()
     * @param string $arrivalDate
     * @param int $nights
     * @param string $status
     * @param \Stuba\StructType\HCNHotelBookingRoomElement[] $room
     * @param string $hCN
     */
    public function __construct($arrivalDate = null, $nights = null, $status = null, array $room = array(), $hCN = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setNights($nights)
            ->setStatus($status)
            ->setRoom($room)
            ->setHCN($hCN);
    }
    /**
     * Get ArrivalDate value
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function setArrivalDate($arrivalDate = null)
    {
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Nights value
     * @return int
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function setNights($nights = null)
    {
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Room value
     * @return \Stuba\StructType\HCNHotelBookingRoomElement[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \Stuba\StructType\HCNHotelBookingRoomElement[] $room
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function setRoom(array $room = array())
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\HCNHotelBookingRoomElement $item
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function addToRoom(\Stuba\StructType\HCNHotelBookingRoomElement $item)
    {
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get HCN value
     * @return string|null
     */
    public function getHCN()
    {
        return $this->HCN;
    }
    /**
     * Set HCN value
     * @param string $hCN
     * @return \Stuba\StructType\HCNHotelBookingElement
     */
    public function setHCN($hCN = null)
    {
        $this->HCN = $hCN;
        return $this;
    }
}
