<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilitySearch StructType
 * @subpackage Structs
 */
class AvailabilitySearch extends AbstractStructBase
{
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegionId;
    /**
     * The HotelId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $HotelId;
    /**
     * The DetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DetailLevel;
    /**
     * The MaxResultsPerHotel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxResultsPerHotel;
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AvailabilitySearch
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The HotelStayDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelStayDetailsElement
     */
    public $HotelStayDetails;
    /**
     * The HotelSearchCriteria
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelSearchCriteriaElement
     */
    public $HotelSearchCriteria;
    /**
     * The CustomDetailLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomDetailLevel;
    /**
     * The Hotels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfInt
     */
    public $Hotels;
    /**
     * Constructor method for AvailabilitySearch
     * @uses AvailabilitySearch::setRegionId()
     * @uses AvailabilitySearch::setHotelId()
     * @uses AvailabilitySearch::setDetailLevel()
     * @uses AvailabilitySearch::setMaxResultsPerHotel()
     * @uses AvailabilitySearch::setXiRequest()
     * @uses AvailabilitySearch::setAuthority()
     * @uses AvailabilitySearch::setHotelStayDetails()
     * @uses AvailabilitySearch::setHotelSearchCriteria()
     * @uses AvailabilitySearch::setCustomDetailLevel()
     * @uses AvailabilitySearch::setHotels()
     * @param int $regionId
     * @param int $hotelId
     * @param string $detailLevel
     * @param int $maxResultsPerHotel
     * @param \Stuba\StructType\AvailabilitySearch $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails
     * @param \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria
     * @param string $customDetailLevel
     * @param \Stuba\ArrayType\ArrayOfInt $hotels
     */
    public function __construct($regionId = null, $hotelId = null, $detailLevel = null, $maxResultsPerHotel = null, \Stuba\StructType\AvailabilitySearch $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails = null, \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria = null, $customDetailLevel = null, \Stuba\ArrayType\ArrayOfInt $hotels = null)
    {
        $this
            ->setRegionId($regionId)
            ->setHotelId($hotelId)
            ->setDetailLevel($detailLevel)
            ->setMaxResultsPerHotel($maxResultsPerHotel)
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setHotelStayDetails($hotelStayDetails)
            ->setHotelSearchCriteria($hotelSearchCriteria)
            ->setCustomDetailLevel($customDetailLevel)
            ->setHotels($hotels);
    }
    /**
     * Get RegionId value
     * @return int
     */
    public function getRegionId()
    {
        return $this->RegionId;
    }
    /**
     * Set RegionId value
     * @param int $regionId
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setRegionId($regionId = null)
    {
        $this->RegionId = $regionId;
        return $this;
    }
    /**
     * Get HotelId value
     * @return int
     */
    public function getHotelId()
    {
        return $this->HotelId;
    }
    /**
     * Set HotelId value
     * @param int $hotelId
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setHotelId($hotelId = null)
    {
        $this->HotelId = $hotelId;
        return $this;
    }
    /**
     * Get DetailLevel value
     * @return string
     */
    public function getDetailLevel()
    {
        return $this->DetailLevel;
    }
    /**
     * Set DetailLevel value
     * @param string $detailLevel
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setDetailLevel($detailLevel = null)
    {
        $this->DetailLevel = $detailLevel;
        return $this;
    }
    /**
     * Get MaxResultsPerHotel value
     * @return int
     */
    public function getMaxResultsPerHotel()
    {
        return $this->MaxResultsPerHotel;
    }
    /**
     * Set MaxResultsPerHotel value
     * @param int $maxResultsPerHotel
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setMaxResultsPerHotel($maxResultsPerHotel = null)
    {
        $this->MaxResultsPerHotel = $maxResultsPerHotel;
        return $this;
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\AvailabilitySearch|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\AvailabilitySearch $xiRequest
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setXiRequest(\Stuba\StructType\AvailabilitySearch $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get HotelStayDetails value
     * @return \Stuba\StructType\HotelStayDetailsElement|null
     */
    public function getHotelStayDetails()
    {
        return $this->HotelStayDetails;
    }
    /**
     * Set HotelStayDetails value
     * @param \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setHotelStayDetails(\Stuba\StructType\HotelStayDetailsElement $hotelStayDetails = null)
    {
        $this->HotelStayDetails = $hotelStayDetails;
        return $this;
    }
    /**
     * Get HotelSearchCriteria value
     * @return \Stuba\StructType\HotelSearchCriteriaElement|null
     */
    public function getHotelSearchCriteria()
    {
        return $this->HotelSearchCriteria;
    }
    /**
     * Set HotelSearchCriteria value
     * @param \Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setHotelSearchCriteria(\Stuba\StructType\HotelSearchCriteriaElement $hotelSearchCriteria = null)
    {
        $this->HotelSearchCriteria = $hotelSearchCriteria;
        return $this;
    }
    /**
     * Get CustomDetailLevel value
     * @return string|null
     */
    public function getCustomDetailLevel()
    {
        return $this->CustomDetailLevel;
    }
    /**
     * Set CustomDetailLevel value
     * @param string $customDetailLevel
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setCustomDetailLevel($customDetailLevel = null)
    {
        $this->CustomDetailLevel = $customDetailLevel;
        return $this;
    }
    /**
     * Get Hotels value
     * @return \Stuba\ArrayType\ArrayOfInt|null
     */
    public function getHotels()
    {
        return $this->Hotels;
    }
    /**
     * Set Hotels value
     * @param \Stuba\ArrayType\ArrayOfInt $hotels
     * @return \Stuba\StructType\AvailabilitySearch
     */
    public function setHotels(\Stuba\ArrayType\ArrayOfInt $hotels = null)
    {
        $this->Hotels = $hotels;
        return $this;
    }
}
