<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferVoucherInfo StructType
 * @subpackage Structs
 */
class TransferVoucherInfo extends AbstractStructBase
{
    /**
     * The PayableBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayableBy;
    /**
     * The VoucherRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherRef;
    /**
     * Constructor method for TransferVoucherInfo
     * @uses TransferVoucherInfo::setPayableBy()
     * @uses TransferVoucherInfo::setVoucherRef()
     * @param string $payableBy
     * @param string $voucherRef
     */
    public function __construct($payableBy = null, $voucherRef = null)
    {
        $this
            ->setPayableBy($payableBy)
            ->setVoucherRef($voucherRef);
    }
    /**
     * Get PayableBy value
     * @return string|null
     */
    public function getPayableBy()
    {
        return $this->PayableBy;
    }
    /**
     * Set PayableBy value
     * @param string $payableBy
     * @return \Stuba\StructType\TransferVoucherInfo
     */
    public function setPayableBy($payableBy = null)
    {
        $this->PayableBy = $payableBy;
        return $this;
    }
    /**
     * Get VoucherRef value
     * @return string|null
     */
    public function getVoucherRef()
    {
        return $this->VoucherRef;
    }
    /**
     * Set VoucherRef value
     * @param string $voucherRef
     * @return \Stuba\StructType\TransferVoucherInfo
     */
    public function setVoucherRef($voucherRef = null)
    {
        $this->VoucherRef = $voucherRef;
        return $this;
    }
}
