<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransferEndPointSupplierInfoElement StructType
 * @subpackage Structs
 */
class TransferEndPointSupplierInfoElement extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier;
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\SupplierCodeElement[]
     */
    public $SupplierCode;
    /**
     * Constructor method for TransferEndPointSupplierInfoElement
     * @uses TransferEndPointSupplierInfoElement::setSupplier()
     * @uses TransferEndPointSupplierInfoElement::setSupplierCode()
     * @param string $supplier
     * @param \Stuba\StructType\SupplierCodeElement[] $supplierCode
     */
    public function __construct($supplier = null, array $supplierCode = array())
    {
        $this
            ->setSupplier($supplier)
            ->setSupplierCode($supplierCode);
    }
    /**
     * Get Supplier value
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param string $supplier
     * @return \Stuba\StructType\TransferEndPointSupplierInfoElement
     */
    public function setSupplier($supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return \Stuba\StructType\SupplierCodeElement[]|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param \Stuba\StructType\SupplierCodeElement[] $supplierCode
     * @return \Stuba\StructType\TransferEndPointSupplierInfoElement
     */
    public function setSupplierCode(array $supplierCode = array())
    {
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Add item to SupplierCode value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\SupplierCodeElement $item
     * @return \Stuba\StructType\TransferEndPointSupplierInfoElement
     */
    public function addToSupplierCode(\Stuba\StructType\SupplierCodeElement $item)
    {
        $this->SupplierCode[] = $item;
        return $this;
    }
}
