<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatingElement StructType
 * @subpackage Structs
 */
class RatingElement extends AbstractStructBase
{
    /**
     * The System
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $System;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Score;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for RatingElement
     * @uses RatingElement::setSystem()
     * @uses RatingElement::setScore()
     * @uses RatingElement::setDescription()
     * @param string $system
     * @param int $score
     * @param string $description
     */
    public function __construct($system = null, $score = null, $description = null)
    {
        $this
            ->setSystem($system)
            ->setScore($score)
            ->setDescription($description);
    }
    /**
     * Get System value
     * @return string|null
     */
    public function getSystem()
    {
        return $this->System;
    }
    /**
     * Set System value
     * @param string $system
     * @return \Stuba\StructType\RatingElement
     */
    public function setSystem($system = null)
    {
        $this->System = $system;
        return $this;
    }
    /**
     * Get Score value
     * @return int|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \Stuba\StructType\RatingElement
     */
    public function setScore($score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Stuba\StructType\RatingElement
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
}
