<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelBookingRoomElement StructType
 * @subpackage Structs
 */
class HotelBookingRoomElement extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The TotalSellingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalSellingPrice;
    /**
     * The TotalBuyingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\MoneyElement
     */
    public $TotalBuyingPrice;
    /**
     * The NightCost
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\NightCostElement[]
     */
    public $NightCost;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $RoomType;
    /**
     * The MealType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\TextEnumPair
     */
    public $MealType;
    /**
     * The Guests
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\ArrayOfChoice5
     */
    public $Guests;
    /**
     * The Extras
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfExtraElement
     */
    public $Extras;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfMessageElement
     */
    public $Messages;
    /**
     * The CanxFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\ArrayType\ArrayOfFeeElement
     */
    public $CanxFees;
    /**
     * The CancellationPolicyStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CancellationPolicyStatus;
    /**
     * The CanxFeeStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CanxFeeStartDate;
    /**
     * Constructor method for HotelBookingRoomElement
     * @uses HotelBookingRoomElement::setStatus()
     * @uses HotelBookingRoomElement::setTotalSellingPrice()
     * @uses HotelBookingRoomElement::setTotalBuyingPrice()
     * @uses HotelBookingRoomElement::setNightCost()
     * @uses HotelBookingRoomElement::setRoomType()
     * @uses HotelBookingRoomElement::setMealType()
     * @uses HotelBookingRoomElement::setGuests()
     * @uses HotelBookingRoomElement::setExtras()
     * @uses HotelBookingRoomElement::setMessages()
     * @uses HotelBookingRoomElement::setCanxFees()
     * @uses HotelBookingRoomElement::setCancellationPolicyStatus()
     * @uses HotelBookingRoomElement::setCanxFeeStartDate()
     * @param string $status
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @param \Stuba\StructType\NightCostElement[] $nightCost
     * @param \Stuba\StructType\TextEnumPair $roomType
     * @param \Stuba\StructType\TextEnumPair $mealType
     * @param \Stuba\StructType\ArrayOfChoice5 $guests
     * @param \Stuba\ArrayType\ArrayOfExtraElement $extras
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @param string $cancellationPolicyStatus
     * @param string $canxFeeStartDate
     */
    public function __construct($status = null, \Stuba\StructType\MoneyElement $totalSellingPrice = null, \Stuba\StructType\MoneyElement $totalBuyingPrice = null, array $nightCost = array(), \Stuba\StructType\TextEnumPair $roomType = null, \Stuba\StructType\TextEnumPair $mealType = null, \Stuba\StructType\ArrayOfChoice5 $guests = null, \Stuba\ArrayType\ArrayOfExtraElement $extras = null, \Stuba\ArrayType\ArrayOfMessageElement $messages = null, \Stuba\ArrayType\ArrayOfFeeElement $canxFees = null, $cancellationPolicyStatus = null, $canxFeeStartDate = null)
    {
        $this
            ->setStatus($status)
            ->setTotalSellingPrice($totalSellingPrice)
            ->setTotalBuyingPrice($totalBuyingPrice)
            ->setNightCost($nightCost)
            ->setRoomType($roomType)
            ->setMealType($mealType)
            ->setGuests($guests)
            ->setExtras($extras)
            ->setMessages($messages)
            ->setCanxFees($canxFees)
            ->setCancellationPolicyStatus($cancellationPolicyStatus)
            ->setCanxFeeStartDate($canxFeeStartDate);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TotalSellingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalSellingPrice()
    {
        return $this->TotalSellingPrice;
    }
    /**
     * Set TotalSellingPrice value
     * @param \Stuba\StructType\MoneyElement $totalSellingPrice
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setTotalSellingPrice(\Stuba\StructType\MoneyElement $totalSellingPrice = null)
    {
        $this->TotalSellingPrice = $totalSellingPrice;
        return $this;
    }
    /**
     * Get TotalBuyingPrice value
     * @return \Stuba\StructType\MoneyElement|null
     */
    public function getTotalBuyingPrice()
    {
        return $this->TotalBuyingPrice;
    }
    /**
     * Set TotalBuyingPrice value
     * @param \Stuba\StructType\MoneyElement $totalBuyingPrice
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setTotalBuyingPrice(\Stuba\StructType\MoneyElement $totalBuyingPrice = null)
    {
        $this->TotalBuyingPrice = $totalBuyingPrice;
        return $this;
    }
    /**
     * Get NightCost value
     * @return \Stuba\StructType\NightCostElement[]|null
     */
    public function getNightCost()
    {
        return $this->NightCost;
    }
    /**
     * Set NightCost value
     * @param \Stuba\StructType\NightCostElement[] $nightCost
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setNightCost(array $nightCost = array())
    {
        $this->NightCost = $nightCost;
        return $this;
    }
    /**
     * Add item to NightCost value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\NightCostElement $item
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function addToNightCost(\Stuba\StructType\NightCostElement $item)
    {
        $this->NightCost[] = $item;
        return $this;
    }
    /**
     * Get RoomType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param \Stuba\StructType\TextEnumPair $roomType
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setRoomType(\Stuba\StructType\TextEnumPair $roomType = null)
    {
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get MealType value
     * @return \Stuba\StructType\TextEnumPair|null
     */
    public function getMealType()
    {
        return $this->MealType;
    }
    /**
     * Set MealType value
     * @param \Stuba\StructType\TextEnumPair $mealType
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setMealType(\Stuba\StructType\TextEnumPair $mealType = null)
    {
        $this->MealType = $mealType;
        return $this;
    }
    /**
     * Get Guests value
     * @return \Stuba\StructType\ArrayOfChoice5|null
     */
    public function getGuests()
    {
        return $this->Guests;
    }
    /**
     * Set Guests value
     * @param \Stuba\StructType\ArrayOfChoice5 $guests
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setGuests(\Stuba\StructType\ArrayOfChoice5 $guests = null)
    {
        $this->Guests = $guests;
        return $this;
    }
    /**
     * Get Extras value
     * @return \Stuba\ArrayType\ArrayOfExtraElement|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \Stuba\ArrayType\ArrayOfExtraElement $extras
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setExtras(\Stuba\ArrayType\ArrayOfExtraElement $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Messages value
     * @return \Stuba\ArrayType\ArrayOfMessageElement|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \Stuba\ArrayType\ArrayOfMessageElement $messages
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setMessages(\Stuba\ArrayType\ArrayOfMessageElement $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
    /**
     * Get CanxFees value
     * @return \Stuba\ArrayType\ArrayOfFeeElement|null
     */
    public function getCanxFees()
    {
        return $this->CanxFees;
    }
    /**
     * Set CanxFees value
     * @param \Stuba\ArrayType\ArrayOfFeeElement $canxFees
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setCanxFees(\Stuba\ArrayType\ArrayOfFeeElement $canxFees = null)
    {
        $this->CanxFees = $canxFees;
        return $this;
    }
    /**
     * Get CancellationPolicyStatus value
     * @return string|null
     */
    public function getCancellationPolicyStatus()
    {
        return $this->CancellationPolicyStatus;
    }
    /**
     * Set CancellationPolicyStatus value
     * @param string $cancellationPolicyStatus
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setCancellationPolicyStatus($cancellationPolicyStatus = null)
    {
        $this->CancellationPolicyStatus = $cancellationPolicyStatus;
        return $this;
    }
    /**
     * Get CanxFeeStartDate value
     * @return string|null
     */
    public function getCanxFeeStartDate()
    {
        return $this->CanxFeeStartDate;
    }
    /**
     * Set CanxFeeStartDate value
     * @param string $canxFeeStartDate
     * @return \Stuba\StructType\HotelBookingRoomElement
     */
    public function setCanxFeeStartDate($canxFeeStartDate = null)
    {
        $this->CanxFeeStartDate = $canxFeeStartDate;
        return $this;
    }
}
