<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingCreateResult StructType
 * @subpackage Structs
 */
class BookingCreateResult extends ResponseBase
{
    /**
     * The CommitLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommitLevel;
    /**
     * The Booking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingElement
     */
    public $Booking;
    /**
     * The HotelDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelDetailsElement
     */
    public $HotelDetails;
    /**
     * Constructor method for BookingCreateResult
     * @uses BookingCreateResult::setCommitLevel()
     * @uses BookingCreateResult::setBooking()
     * @uses BookingCreateResult::setHotelDetails()
     * @param string $commitLevel
     * @param \Stuba\StructType\BookingElement $booking
     * @param \Stuba\StructType\HotelDetailsElement $hotelDetails
     */
    public function __construct($commitLevel = null, \Stuba\StructType\BookingElement $booking = null, \Stuba\StructType\HotelDetailsElement $hotelDetails = null)
    {
        $this
            ->setCommitLevel($commitLevel)
            ->setBooking($booking)
            ->setHotelDetails($hotelDetails);
    }
    /**
     * Get CommitLevel value
     * @return string|null
     */
    public function getCommitLevel()
    {
        return $this->CommitLevel;
    }
    /**
     * Set CommitLevel value
     * @param string $commitLevel
     * @return \Stuba\StructType\BookingCreateResult
     */
    public function setCommitLevel($commitLevel = null)
    {
        $this->CommitLevel = $commitLevel;
        return $this;
    }
    /**
     * Get Booking value
     * @return \Stuba\StructType\BookingElement|null
     */
    public function getBooking()
    {
        return $this->Booking;
    }
    /**
     * Set Booking value
     * @param \Stuba\StructType\BookingElement $booking
     * @return \Stuba\StructType\BookingCreateResult
     */
    public function setBooking(\Stuba\StructType\BookingElement $booking = null)
    {
        $this->Booking = $booking;
        return $this;
    }
    /**
     * Get HotelDetails value
     * @return \Stuba\StructType\HotelDetailsElement|null
     */
    public function getHotelDetails()
    {
        return $this->HotelDetails;
    }
    /**
     * Set HotelDetails value
     * @param \Stuba\StructType\HotelDetailsElement $hotelDetails
     * @return \Stuba\StructType\BookingCreateResult
     */
    public function setHotelDetails(\Stuba\StructType\HotelDetailsElement $hotelDetails = null)
    {
        $this->HotelDetails = $hotelDetails;
        return $this;
    }
}
