<?php

namespace Stuba\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingCreate StructType
 * @subpackage Structs
 */
class BookingCreate extends AbstractStructBase
{
    /**
     * The xiRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\BookingCreate
     */
    public $xiRequest;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\AuthorityElement
     */
    public $Authority;
    /**
     * The QuoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QuoteId;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\CustomerElement
     */
    public $Customer;
    /**
     * The HotelStayDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\HotelStayDetailsElement
     */
    public $HotelStayDetails;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Stuba\StructType\PaymentDetailsElement
     */
    public $PaymentDetails;
    /**
     * The CommitLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommitLevel;
    /**
     * The AgentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentReference;
    /**
     * The HotelBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\CreateBookingElement[]
     */
    public $HotelBooking;
    /**
     * The TransferBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Stuba\StructType\CreateTransferBookingElement[]
     */
    public $TransferBooking;
    /**
     * Constructor method for BookingCreate
     * @uses BookingCreate::setXiRequest()
     * @uses BookingCreate::setAuthority()
     * @uses BookingCreate::setQuoteId()
     * @uses BookingCreate::setCustomer()
     * @uses BookingCreate::setHotelStayDetails()
     * @uses BookingCreate::setPaymentDetails()
     * @uses BookingCreate::setCommitLevel()
     * @uses BookingCreate::setAgentReference()
     * @uses BookingCreate::setHotelBooking()
     * @uses BookingCreate::setTransferBooking()
     * @param \Stuba\StructType\BookingCreate $xiRequest
     * @param \Stuba\StructType\AuthorityElement $authority
     * @param string $quoteId
     * @param \Stuba\StructType\CustomerElement $customer
     * @param \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails
     * @param \Stuba\StructType\PaymentDetailsElement $paymentDetails
     * @param string $commitLevel
     * @param string $agentReference
     * @param \Stuba\StructType\CreateBookingElement[] $hotelBooking
     * @param \Stuba\StructType\CreateTransferBookingElement[] $transferBooking
     */
    public function __construct(\Stuba\StructType\BookingCreate $xiRequest = null, \Stuba\StructType\AuthorityElement $authority = null, $quoteId = null, \Stuba\StructType\CustomerElement $customer = null, \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails = null, \Stuba\StructType\PaymentDetailsElement $paymentDetails = null, $commitLevel = null, $agentReference = null, array $hotelBooking = array(), array $transferBooking = array())
    {
        $this
            ->setXiRequest($xiRequest)
            ->setAuthority($authority)
            ->setQuoteId($quoteId)
            ->setCustomer($customer)
            ->setHotelStayDetails($hotelStayDetails)
            ->setPaymentDetails($paymentDetails)
            ->setCommitLevel($commitLevel)
            ->setAgentReference($agentReference)
            ->setHotelBooking($hotelBooking)
            ->setTransferBooking($transferBooking);
    }
    /**
     * Get xiRequest value
     * @return \Stuba\StructType\BookingCreate|null
     */
    public function getXiRequest()
    {
        return $this->xiRequest;
    }
    /**
     * Set xiRequest value
     * @param \Stuba\StructType\BookingCreate $xiRequest
     * @return \Stuba\StructType\BookingCreate
     */
    public function setXiRequest(\Stuba\StructType\BookingCreate $xiRequest = null)
    {
        $this->xiRequest = $xiRequest;
        return $this;
    }
    /**
     * Get Authority value
     * @return \Stuba\StructType\AuthorityElement|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param \Stuba\StructType\AuthorityElement $authority
     * @return \Stuba\StructType\BookingCreate
     */
    public function setAuthority(\Stuba\StructType\AuthorityElement $authority = null)
    {
        $this->Authority = $authority;
        return $this;
    }
    /**
     * Get QuoteId value
     * @return string|null
     */
    public function getQuoteId()
    {
        return $this->QuoteId;
    }
    /**
     * Set QuoteId value
     * @param string $quoteId
     * @return \Stuba\StructType\BookingCreate
     */
    public function setQuoteId($quoteId = null)
    {
        $this->QuoteId = $quoteId;
        return $this;
    }
    /**
     * Get Customer value
     * @return \Stuba\StructType\CustomerElement|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \Stuba\StructType\CustomerElement $customer
     * @return \Stuba\StructType\BookingCreate
     */
    public function setCustomer(\Stuba\StructType\CustomerElement $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get HotelStayDetails value
     * @return \Stuba\StructType\HotelStayDetailsElement|null
     */
    public function getHotelStayDetails()
    {
        return $this->HotelStayDetails;
    }
    /**
     * Set HotelStayDetails value
     * @param \Stuba\StructType\HotelStayDetailsElement $hotelStayDetails
     * @return \Stuba\StructType\BookingCreate
     */
    public function setHotelStayDetails(\Stuba\StructType\HotelStayDetailsElement $hotelStayDetails = null)
    {
        $this->HotelStayDetails = $hotelStayDetails;
        return $this;
    }
    /**
     * Get PaymentDetails value
     * @return \Stuba\StructType\PaymentDetailsElement|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \Stuba\StructType\PaymentDetailsElement $paymentDetails
     * @return \Stuba\StructType\BookingCreate
     */
    public function setPaymentDetails(\Stuba\StructType\PaymentDetailsElement $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get CommitLevel value
     * @return string|null
     */
    public function getCommitLevel()
    {
        return $this->CommitLevel;
    }
    /**
     * Set CommitLevel value
     * @param string $commitLevel
     * @return \Stuba\StructType\BookingCreate
     */
    public function setCommitLevel($commitLevel = null)
    {
        $this->CommitLevel = $commitLevel;
        return $this;
    }
    /**
     * Get AgentReference value
     * @return string|null
     */
    public function getAgentReference()
    {
        return $this->AgentReference;
    }
    /**
     * Set AgentReference value
     * @param string $agentReference
     * @return \Stuba\StructType\BookingCreate
     */
    public function setAgentReference($agentReference = null)
    {
        $this->AgentReference = $agentReference;
        return $this;
    }
    /**
     * Get HotelBooking value
     * @return \Stuba\StructType\CreateBookingElement[]|null
     */
    public function getHotelBooking()
    {
        return $this->HotelBooking;
    }
    /**
     * Set HotelBooking value
     * @param \Stuba\StructType\CreateBookingElement[] $hotelBooking
     * @return \Stuba\StructType\BookingCreate
     */
    public function setHotelBooking(array $hotelBooking = array())
    {
        $this->HotelBooking = $hotelBooking;
        return $this;
    }
    /**
     * Add item to HotelBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\CreateBookingElement $item
     * @return \Stuba\StructType\BookingCreate
     */
    public function addToHotelBooking(\Stuba\StructType\CreateBookingElement $item)
    {
        $this->HotelBooking[] = $item;
        return $this;
    }
    /**
     * Get TransferBooking value
     * @return \Stuba\StructType\CreateTransferBookingElement[]|null
     */
    public function getTransferBooking()
    {
        return $this->TransferBooking;
    }
    /**
     * Set TransferBooking value
     * @param \Stuba\StructType\CreateTransferBookingElement[] $transferBooking
     * @return \Stuba\StructType\BookingCreate
     */
    public function setTransferBooking(array $transferBooking = array())
    {
        $this->TransferBooking = $transferBooking;
        return $this;
    }
    /**
     * Add item to TransferBooking value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\CreateTransferBookingElement $item
     * @return \Stuba\StructType\BookingCreate
     */
    public function addToTransferBooking(\Stuba\StructType\CreateTransferBookingElement $item)
    {
        $this->TransferBooking[] = $item;
        return $this;
    }
}
