<?php

namespace Stuba\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Customer ServiceType
 * @subpackage Services
 */
class Customer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CustomerAmend
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Stuba\StructType\CustomerAmend $parameters
     * @return \Stuba\StructType\CustomerAmendResponse|bool
     */
    public function CustomerAmend(\Stuba\StructType\CustomerAmend $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CustomerAmend($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Stuba\StructType\CustomerAmendResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
