<?php

namespace Stuba\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFeeElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfFeeElement extends AbstractStructArrayBase
{
    /**
     * The Fee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Stuba\StructType\FeeElement[]
     */
    public $Fee;
    /**
     * Constructor method for ArrayOfFeeElement
     * @uses ArrayOfFeeElement::setFee()
     * @param \Stuba\StructType\FeeElement[] $fee
     */
    public function __construct(array $fee = array())
    {
        $this
            ->setFee($fee);
    }
    /**
     * Get Fee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Stuba\StructType\FeeElement[]|null
     */
    public function getFee()
    {
        return isset($this->Fee) ? $this->Fee : null;
    }
    /**
     * Set Fee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Stuba\StructType\FeeElement[] $fee
     * @return \Stuba\ArrayType\ArrayOfFeeElement
     */
    public function setFee(array $fee = array())
    {
        if (is_null($fee) || (is_array($fee) && empty($fee))) {
            unset($this->Fee);
        } else {
            $this->Fee = $fee;
        }
        return $this;
    }
    /**
     * Add item to Fee value
     * @throws \InvalidArgumentException
     * @param \Stuba\StructType\FeeElement $item
     * @return \Stuba\ArrayType\ArrayOfFeeElement
     */
    public function addToFee(\Stuba\StructType\FeeElement $item)
    {
        $this->Fee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Stuba\StructType\FeeElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Stuba\StructType\FeeElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Stuba\StructType\FeeElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Stuba\StructType\FeeElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Stuba\StructType\FeeElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Fee
     */
    public function getAttributeName()
    {
        return 'Fee';
    }
}
