<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToleranceDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: The object containing how tolerant this line is to overrun and underruns.
 * @subpackage Structs
 */
class ToleranceDetails extends AbstractStructBase
{
    /**
     * The uom
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure; values are enumerated. | The UOM
     * - base: ns2:ToleranceUomType
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * - type: ns5:ISO20022UomCode
     * @var string
     */
    public $uom;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * The tolerance
     * @var string
     */
    public $tolerance;
    /**
     * Constructor method for ToleranceDetails
     * @uses ToleranceDetails::setUom()
     * @uses ToleranceDetails::setValue()
     * @uses ToleranceDetails::setTolerance()
     * @param string $uom
     * @param float $value
     * @param string $tolerance
     */
    public function __construct($uom = null, $value = null, $tolerance = null)
    {
        $this
            ->setUom($uom)
            ->setValue($value)
            ->setTolerance($tolerance);
    }
    /**
     * Get uom value
     * @return string|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * Set uom value
     * @param string $uom
     * @return \StructType\ToleranceDetails
     */
    public function setUom($uom = null)
    {
        // validation for constraint: string
        if (!is_null($uom) && !is_string($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uom, true), gettype($uom)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($uom) && mb_strlen($uom) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($uom)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uom) && mb_strlen($uom) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uom)), __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\ToleranceDetails
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get tolerance value
     * @return string|null
     */
    public function getTolerance()
    {
        return $this->tolerance;
    }
    /**
     * Set tolerance value
     * @uses \EnumType\ToleranceType::valueIsValid()
     * @uses \EnumType\ToleranceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tolerance
     * @return \StructType\ToleranceDetails
     */
    public function setTolerance($tolerance = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ToleranceType::valueIsValid($tolerance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ToleranceType', is_array($tolerance) ? implode(', ', $tolerance) : var_export($tolerance, true), implode(', ', \EnumType\ToleranceType::getValidValues())), __LINE__);
        }
        $this->tolerance = $tolerance;
        return $this;
    }
}
