<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPOResponse StructType
 * @subpackage Structs
 */
class SendPOResponse extends AbstractStructBase
{
    /**
     * The transactionId
     * Meta information extracted from the WSDL
     * - documentation: The transaction id of the PO submittal
     * - minOccurs: 0
     * @var string
     */
    public $transactionId;
    /**
     * The ServiceMessageArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:ServiceMessageArray
     * @var \ArrayType\ServiceMessageArray
     */
    public $ServiceMessageArray;
    /**
     * Constructor method for SendPOResponse
     * @uses SendPOResponse::setTransactionId()
     * @uses SendPOResponse::setServiceMessageArray()
     * @param string $transactionId
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     */
    public function __construct($transactionId = null, \ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this
            ->setTransactionId($transactionId)
            ->setServiceMessageArray($serviceMessageArray);
    }
    /**
     * Get transactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }
    /**
     * Set transactionId value
     * @param string $transactionId
     * @return \StructType\SendPOResponse
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        $this->transactionId = $transactionId;
        return $this;
    }
    /**
     * Get ServiceMessageArray value
     * @return \ArrayType\ServiceMessageArray|null
     */
    public function getServiceMessageArray()
    {
        return $this->ServiceMessageArray;
    }
    /**
     * Set ServiceMessageArray value
     * @param \ArrayType\ServiceMessageArray $serviceMessageArray
     * @return \StructType\SendPOResponse
     */
    public function setServiceMessageArray(\ArrayType\ServiceMessageArray $serviceMessageArray = null)
    {
        $this->ServiceMessageArray = $serviceMessageArray;
        return $this;
    }
}
