<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPORequest StructType
 * @subpackage Structs
 */
class SendPORequest extends AbstractStructBase
{
    /**
     * The wsVersion
     * Meta information extracted from the WSDL
     * - documentation: The Standard Version of the Web Service being referenced
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns3:wsVersion
     * @var string
     */
    public $wsVersion;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: The customer Id or any other agreed upon Id.
     * - ref: ns3:id
     * @var string
     */
    public $id;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: The password associated with the Id
     * - base: xsd:token
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns3:password
     * @var string
     */
    public $password;
    /**
     * The PO
     * Meta information extracted from the WSDL
     * - ref: ns1:PO
     * @var \StructType\PO
     */
    public $PO;
    /**
     * Constructor method for SendPORequest
     * @uses SendPORequest::setWsVersion()
     * @uses SendPORequest::setId()
     * @uses SendPORequest::setPassword()
     * @uses SendPORequest::setPO()
     * @param string $wsVersion
     * @param string $id
     * @param string $password
     * @param \StructType\PO $pO
     */
    public function __construct($wsVersion = null, $id = null, $password = null, \StructType\PO $pO = null)
    {
        $this
            ->setWsVersion($wsVersion)
            ->setId($id)
            ->setPassword($password)
            ->setPO($pO);
    }
    /**
     * Get wsVersion value
     * @return string|null
     */
    public function getWsVersion()
    {
        return $this->wsVersion;
    }
    /**
     * Set wsVersion value
     * @param string $wsVersion
     * @return \StructType\SendPORequest
     */
    public function setWsVersion($wsVersion = null)
    {
        // validation for constraint: string
        if (!is_null($wsVersion) && !is_string($wsVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsVersion, true), gettype($wsVersion)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($wsVersion)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($wsVersion) && mb_strlen($wsVersion) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($wsVersion)), __LINE__);
        }
        $this->wsVersion = $wsVersion;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SendPORequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\SendPORequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($password) && mb_strlen($password) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($password) && mb_strlen($password) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get PO value
     * @return \StructType\PO|null
     */
    public function getPO()
    {
        return $this->PO;
    }
    /**
     * Set PO value
     * @param \StructType\PO $pO
     * @return \StructType\SendPORequest
     */
    public function setPO(\StructType\PO $pO = null)
    {
        $this->PO = $pO;
        return $this;
    }
}
