<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quantity StructType
 * Meta information extracted from the WSDL
 * - documentation: The quantity object that contains the value and unit of measure
 * @subpackage Structs
 */
class Quantity extends AbstractStructBase
{
    /**
     * The uom
     * Meta information extracted from the WSDL
     * - base: ns2:QuantityUomType
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $uom;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - documentation: The quantity value
     * @var float
     */
    public $value;
    /**
     * Constructor method for Quantity
     * @uses Quantity::setUom()
     * @uses Quantity::setValue()
     * @param string $uom
     * @param float $value
     */
    public function __construct($uom = null, $value = null)
    {
        $this
            ->setUom($uom)
            ->setValue($value);
    }
    /**
     * Get uom value
     * @return string|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * Set uom value
     * @param string $uom
     * @return \StructType\Quantity
     */
    public function setUom($uom = null)
    {
        // validation for constraint: string
        if (!is_null($uom) && !is_string($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uom, true), gettype($uom)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($uom) && mb_strlen($uom) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($uom)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uom) && mb_strlen($uom) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uom)), __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Quantity
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
