<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO StructType
 * @subpackage Structs
 */
class PO extends AbstractStructBase
{
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - documentation: The type of data transferred in the request
     * - base: ns3:OrderTypeType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $orderType;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - documentation: Purchase order number
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $orderNumber;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - documentation: The date and time of the purchase order.
     * @var string
     */
    public $orderDate;
    /**
     * The lastModified
     * Meta information extracted from the WSDL
     * - documentation: The date and time the purchase order was last modified
     * - minOccurs: 0
     * @var string
     */
    public $lastModified;
    /**
     * The totalAmount
     * Meta information extracted from the WSDL
     * - documentation: The total dollar amount of the purchase order
     * @var float
     */
    public $totalAmount;
    /**
     * The paymentTerms
     * Meta information extracted from the WSDL
     * - documentation: The terms of the purchase order. i.e. NET15, NET30, etc.
     * - minOccurs: 0
     * @var string
     */
    public $paymentTerms;
    /**
     * The rush
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate a rush on the purchase order.
     * @var bool
     */
    public $rush;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - ref: ns3:currency
     * @var string
     */
    public $currency;
    /**
     * The DigitalProof
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns3:DigitalProof
     * @var \StructType\DigitalProof
     */
    public $DigitalProof;
    /**
     * The OrderContactArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\OrderContactArray
     */
    public $OrderContactArray;
    /**
     * The ShipmentArray
     * @var \ArrayType\ShipmentArray
     */
    public $ShipmentArray;
    /**
     * The LineItemArray
     * @var \ArrayType\LineItemArray
     */
    public $LineItemArray;
    /**
     * The termsAndConditions
     * Meta information extracted from the WSDL
     * - documentation: The terms and conditions for this purchase order. Information that is order specific or information dealing with the configuration or shipment of the order should not be entered here.
     * @var string
     */
    public $termsAndConditions;
    /**
     * The salesChannel
     * Meta information extracted from the WSDL
     * - documentation: The sales channel
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesChannel;
    /**
     * The promoCode
     * Meta information extracted from the WSDL
     * - documentation: The promotion code
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $promoCode;
    /**
     * The TaxInformationArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\TaxInformationArray
     */
    public $TaxInformationArray;
    /**
     * Constructor method for PO
     * @uses PO::setOrderType()
     * @uses PO::setOrderNumber()
     * @uses PO::setOrderDate()
     * @uses PO::setLastModified()
     * @uses PO::setTotalAmount()
     * @uses PO::setPaymentTerms()
     * @uses PO::setRush()
     * @uses PO::setCurrency()
     * @uses PO::setDigitalProof()
     * @uses PO::setOrderContactArray()
     * @uses PO::setShipmentArray()
     * @uses PO::setLineItemArray()
     * @uses PO::setTermsAndConditions()
     * @uses PO::setSalesChannel()
     * @uses PO::setPromoCode()
     * @uses PO::setTaxInformationArray()
     * @param string $orderType
     * @param string $orderNumber
     * @param string $orderDate
     * @param string $lastModified
     * @param float $totalAmount
     * @param string $paymentTerms
     * @param bool $rush
     * @param string $currency
     * @param \StructType\DigitalProof $digitalProof
     * @param \ArrayType\OrderContactArray $orderContactArray
     * @param \ArrayType\ShipmentArray $shipmentArray
     * @param \ArrayType\LineItemArray $lineItemArray
     * @param string $termsAndConditions
     * @param string $salesChannel
     * @param string $promoCode
     * @param \ArrayType\TaxInformationArray $taxInformationArray
     */
    public function __construct($orderType = null, $orderNumber = null, $orderDate = null, $lastModified = null, $totalAmount = null, $paymentTerms = null, $rush = null, $currency = null, \StructType\DigitalProof $digitalProof = null, \ArrayType\OrderContactArray $orderContactArray = null, \ArrayType\ShipmentArray $shipmentArray = null, \ArrayType\LineItemArray $lineItemArray = null, $termsAndConditions = null, $salesChannel = null, $promoCode = null, \ArrayType\TaxInformationArray $taxInformationArray = null)
    {
        $this
            ->setOrderType($orderType)
            ->setOrderNumber($orderNumber)
            ->setOrderDate($orderDate)
            ->setLastModified($lastModified)
            ->setTotalAmount($totalAmount)
            ->setPaymentTerms($paymentTerms)
            ->setRush($rush)
            ->setCurrency($currency)
            ->setDigitalProof($digitalProof)
            ->setOrderContactArray($orderContactArray)
            ->setShipmentArray($shipmentArray)
            ->setLineItemArray($lineItemArray)
            ->setTermsAndConditions($termsAndConditions)
            ->setSalesChannel($salesChannel)
            ->setPromoCode($promoCode)
            ->setTaxInformationArray($taxInformationArray);
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @param string $orderType
     * @return \StructType\PO
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderType, true), gettype($orderType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($orderType) && mb_strlen($orderType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($orderType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderType) && mb_strlen($orderType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderType)), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\PO
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($orderNumber) && mb_strlen($orderNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($orderNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($orderNumber) && mb_strlen($orderNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\PO
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get lastModified value
     * @return string|null
     */
    public function getLastModified()
    {
        return $this->lastModified;
    }
    /**
     * Set lastModified value
     * @param string $lastModified
     * @return \StructType\PO
     */
    public function setLastModified($lastModified = null)
    {
        // validation for constraint: string
        if (!is_null($lastModified) && !is_string($lastModified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModified, true), gettype($lastModified)), __LINE__);
        }
        $this->lastModified = $lastModified;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\PO
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get paymentTerms value
     * @return string|null
     */
    public function getPaymentTerms()
    {
        return $this->paymentTerms;
    }
    /**
     * Set paymentTerms value
     * @param string $paymentTerms
     * @return \StructType\PO
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerms) && !is_string($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTerms, true), gettype($paymentTerms)), __LINE__);
        }
        $this->paymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get rush value
     * @return bool|null
     */
    public function getRush()
    {
        return $this->rush;
    }
    /**
     * Set rush value
     * @param bool $rush
     * @return \StructType\PO
     */
    public function setRush($rush = null)
    {
        // validation for constraint: boolean
        if (!is_null($rush) && !is_bool($rush)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rush, true), gettype($rush)), __LINE__);
        }
        $this->rush = $rush;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\CurrencyCodeType::valueIsValid()
     * @uses \EnumType\CurrencyCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\PO
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CurrencyCodeType::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CurrencyCodeType', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\CurrencyCodeType::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get DigitalProof value
     * @return \StructType\DigitalProof|null
     */
    public function getDigitalProof()
    {
        return $this->DigitalProof;
    }
    /**
     * Set DigitalProof value
     * @param \StructType\DigitalProof $digitalProof
     * @return \StructType\PO
     */
    public function setDigitalProof(\StructType\DigitalProof $digitalProof = null)
    {
        $this->DigitalProof = $digitalProof;
        return $this;
    }
    /**
     * Get OrderContactArray value
     * @return \ArrayType\OrderContactArray|null
     */
    public function getOrderContactArray()
    {
        return $this->OrderContactArray;
    }
    /**
     * Set OrderContactArray value
     * @param \ArrayType\OrderContactArray $orderContactArray
     * @return \StructType\PO
     */
    public function setOrderContactArray(\ArrayType\OrderContactArray $orderContactArray = null)
    {
        $this->OrderContactArray = $orderContactArray;
        return $this;
    }
    /**
     * Get ShipmentArray value
     * @return \ArrayType\ShipmentArray|null
     */
    public function getShipmentArray()
    {
        return $this->ShipmentArray;
    }
    /**
     * Set ShipmentArray value
     * @param \ArrayType\ShipmentArray $shipmentArray
     * @return \StructType\PO
     */
    public function setShipmentArray(\ArrayType\ShipmentArray $shipmentArray = null)
    {
        $this->ShipmentArray = $shipmentArray;
        return $this;
    }
    /**
     * Get LineItemArray value
     * @return \ArrayType\LineItemArray|null
     */
    public function getLineItemArray()
    {
        return $this->LineItemArray;
    }
    /**
     * Set LineItemArray value
     * @param \ArrayType\LineItemArray $lineItemArray
     * @return \StructType\PO
     */
    public function setLineItemArray(\ArrayType\LineItemArray $lineItemArray = null)
    {
        $this->LineItemArray = $lineItemArray;
        return $this;
    }
    /**
     * Get termsAndConditions value
     * @return string|null
     */
    public function getTermsAndConditions()
    {
        return $this->termsAndConditions;
    }
    /**
     * Set termsAndConditions value
     * @param string $termsAndConditions
     * @return \StructType\PO
     */
    public function setTermsAndConditions($termsAndConditions = null)
    {
        // validation for constraint: string
        if (!is_null($termsAndConditions) && !is_string($termsAndConditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsAndConditions, true), gettype($termsAndConditions)), __LINE__);
        }
        $this->termsAndConditions = $termsAndConditions;
        return $this;
    }
    /**
     * Get salesChannel value
     * @return string|null
     */
    public function getSalesChannel()
    {
        return $this->salesChannel;
    }
    /**
     * Set salesChannel value
     * @param string $salesChannel
     * @return \StructType\PO
     */
    public function setSalesChannel($salesChannel = null)
    {
        // validation for constraint: string
        if (!is_null($salesChannel) && !is_string($salesChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesChannel, true), gettype($salesChannel)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($salesChannel) && mb_strlen($salesChannel) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($salesChannel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($salesChannel) && mb_strlen($salesChannel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($salesChannel)), __LINE__);
        }
        $this->salesChannel = $salesChannel;
        return $this;
    }
    /**
     * Get promoCode value
     * @return string|null
     */
    public function getPromoCode()
    {
        return $this->promoCode;
    }
    /**
     * Set promoCode value
     * @param string $promoCode
     * @return \StructType\PO
     */
    public function setPromoCode($promoCode = null)
    {
        // validation for constraint: string
        if (!is_null($promoCode) && !is_string($promoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoCode, true), gettype($promoCode)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($promoCode) && mb_strlen($promoCode) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($promoCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promoCode) && mb_strlen($promoCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promoCode)), __LINE__);
        }
        $this->promoCode = $promoCode;
        return $this;
    }
    /**
     * Get TaxInformationArray value
     * @return \ArrayType\TaxInformationArray|null
     */
    public function getTaxInformationArray()
    {
        return $this->TaxInformationArray;
    }
    /**
     * Set TaxInformationArray value
     * @param \ArrayType\TaxInformationArray $taxInformationArray
     * @return \StructType\PO
     */
    public function setTaxInformationArray(\ArrayType\TaxInformationArray $taxInformationArray = null)
    {
        $this->TaxInformationArray = $taxInformationArray;
        return $this;
    }
}
