<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta information extracted from the WSDL
 * - documentation: The locationId from the supplier's PromoStandards Product Pricing and Configuration service | The locationName from the supplier's PromoStandards Product Pricing and Configuration service.
 * @subpackage Structs
 */
class Location extends AbstractStructBase
{
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - documentation: The location name
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:locationName
     * @var string
     */
    public $locationName;
    /**
     * The DecorationArray
     * @var \ArrayType\DecorationArray
     */
    public $DecorationArray;
    /**
     * The locationLinkId
     * Meta information extracted from the WSDL
     * - documentation: An identifier to be used within the Part Array to link configured locations to a part. Due to different colors and sizes, identical locations may need to be decorated differently.
     * @var int
     */
    public $locationLinkId;
    /**
     * The locationId
     * Meta information extracted from the WSDL
     * - ref: ns2:locationId
     * @var int
     */
    public $locationId;
    /**
     * Constructor method for Location
     * @uses Location::setLocationName()
     * @uses Location::setDecorationArray()
     * @uses Location::setLocationLinkId()
     * @uses Location::setLocationId()
     * @param string $locationName
     * @param \ArrayType\DecorationArray $decorationArray
     * @param int $locationLinkId
     * @param int $locationId
     */
    public function __construct($locationName = null, \ArrayType\DecorationArray $decorationArray = null, $locationLinkId = null, $locationId = null)
    {
        $this
            ->setLocationName($locationName)
            ->setDecorationArray($decorationArray)
            ->setLocationLinkId($locationLinkId)
            ->setLocationId($locationId);
    }
    /**
     * Get locationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param string $locationName
     * @return \StructType\Location
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationName, true), gettype($locationName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($locationName) && mb_strlen($locationName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($locationName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($locationName) && mb_strlen($locationName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($locationName)), __LINE__);
        }
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get DecorationArray value
     * @return \ArrayType\DecorationArray|null
     */
    public function getDecorationArray()
    {
        return $this->DecorationArray;
    }
    /**
     * Set DecorationArray value
     * @param \ArrayType\DecorationArray $decorationArray
     * @return \StructType\Location
     */
    public function setDecorationArray(\ArrayType\DecorationArray $decorationArray = null)
    {
        $this->DecorationArray = $decorationArray;
        return $this;
    }
    /**
     * Get locationLinkId value
     * @return int|null
     */
    public function getLocationLinkId()
    {
        return $this->locationLinkId;
    }
    /**
     * Set locationLinkId value
     * @param int $locationLinkId
     * @return \StructType\Location
     */
    public function setLocationLinkId($locationLinkId = null)
    {
        // validation for constraint: int
        if (!is_null($locationLinkId) && !(is_int($locationLinkId) || ctype_digit($locationLinkId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locationLinkId, true), gettype($locationLinkId)), __LINE__);
        }
        $this->locationLinkId = $locationLinkId;
        return $this;
    }
    /**
     * Get locationId value
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->locationId;
    }
    /**
     * Set locationId value
     * @param int $locationId
     * @return \StructType\Location
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !(is_int($locationId) || ctype_digit($locationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        $this->locationId = $locationId;
        return $this;
    }
}
