<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightDetails StructType
 * @subpackage Structs
 */
class FreightDetails extends AbstractStructBase
{
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - documentation: The carrier used for this shipment.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $carrier;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - documentation: The service type requested by the carrier.
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $service;
    /**
     * Constructor method for FreightDetails
     * @uses FreightDetails::setCarrier()
     * @uses FreightDetails::setService()
     * @param string $carrier
     * @param string $service
     */
    public function __construct($carrier = null, $service = null)
    {
        $this
            ->setCarrier($carrier)
            ->setService($service);
    }
    /**
     * Get carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @param string $carrier
     * @return \StructType\FreightDetails
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($carrier) && mb_strlen($carrier) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($carrier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($carrier) && mb_strlen($carrier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($carrier)), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\FreightDetails
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($service) && mb_strlen($service) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($service)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($service) && mb_strlen($service) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
}
