<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DigitalProofAddress StructType
 * @subpackage Structs
 */
class DigitalProofAddress extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: The type of address of the digital proof. Values are enumerated: Email, Webservice
     * - base: ns2:DigitalProofAddressTypeType
     * - maxLength: 64
     * - minLength: 1
     * @var string
     */
    public $type;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: The email of the contact
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * - ref: ns2:email
     * @var string
     */
    public $email;
    /**
     * The lineItemGroupingId
     * Meta information extracted from the WSDL
     * - ref: ns2:lineItemGroupingId
     * @var int
     */
    public $lineItemGroupingId;
    /**
     * Constructor method for DigitalProofAddress
     * @uses DigitalProofAddress::setType()
     * @uses DigitalProofAddress::setEmail()
     * @uses DigitalProofAddress::setLineItemGroupingId()
     * @param string $type
     * @param string $email
     * @param int $lineItemGroupingId
     */
    public function __construct($type = null, $email = null, $lineItemGroupingId = null)
    {
        $this
            ->setType($type)
            ->setEmail($email)
            ->setLineItemGroupingId($lineItemGroupingId);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\DigitalProofAddress
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($type) && mb_strlen($type) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\DigitalProofAddress
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($email) && mb_strlen($email) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email) && mb_strlen($email) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get lineItemGroupingId value
     * @return int|null
     */
    public function getLineItemGroupingId()
    {
        return $this->lineItemGroupingId;
    }
    /**
     * Set lineItemGroupingId value
     * @param int $lineItemGroupingId
     * @return \StructType\DigitalProofAddress
     */
    public function setLineItemGroupingId($lineItemGroupingId = null)
    {
        // validation for constraint: int
        if (!is_null($lineItemGroupingId) && !(is_int($lineItemGroupingId) || ctype_digit($lineItemGroupingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineItemGroupingId, true), gettype($lineItemGroupingId)), __LINE__);
        }
        $this->lineItemGroupingId = $lineItemGroupingId;
        return $this;
    }
}
