<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Use comments only when absolutely necessary, as it may cause delays in order processing. | The email
 * @subpackage Structs
 */
class ContactDetails extends AbstractStructBase
{
    /**
     * The attentionTo
     * Meta information extracted from the WSDL
     * - documentation: Attention To (first and last name of contact)
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $attentionTo;
    /**
     * The companyName
     * Meta information extracted from the WSDL
     * - documentation: The company name
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $companyName;
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - documentation: Address line 1
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $address1;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - documentation: Address line 2
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - documentation: Address line 3
     * - base: xsd:string
     * - maxLength: 35
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $address3;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - documentation: The city
     * - base: xsd:string
     * - maxLength: 30
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - documentation: The 2 character US state abbreviation or 2-3 character non-US region
     * - base: xsd:string
     * - maxLength: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - documentation: The postal code
     * - base: xsd:string
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: The country
     * - base: ns3:ISO3166CountyCode
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: The email of the contact
     * - base: xsd:string
     * - maxLength: 128
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:email
     * @var string
     */
    public $email;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - documentation: The phone
     * - base: xsd:string
     * - maxLength: 32
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:comments
     * @var string
     */
    public $comments;
    /**
     * Constructor method for ContactDetails
     * @uses ContactDetails::setAttentionTo()
     * @uses ContactDetails::setCompanyName()
     * @uses ContactDetails::setAddress1()
     * @uses ContactDetails::setAddress2()
     * @uses ContactDetails::setAddress3()
     * @uses ContactDetails::setCity()
     * @uses ContactDetails::setRegion()
     * @uses ContactDetails::setPostalCode()
     * @uses ContactDetails::setCountry()
     * @uses ContactDetails::setEmail()
     * @uses ContactDetails::setPhone()
     * @uses ContactDetails::setComments()
     * @param string $attentionTo
     * @param string $companyName
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $city
     * @param string $region
     * @param string $postalCode
     * @param string $country
     * @param string $email
     * @param string $phone
     * @param string $comments
     */
    public function __construct($attentionTo = null, $companyName = null, $address1 = null, $address2 = null, $address3 = null, $city = null, $region = null, $postalCode = null, $country = null, $email = null, $phone = null, $comments = null)
    {
        $this
            ->setAttentionTo($attentionTo)
            ->setCompanyName($companyName)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setCity($city)
            ->setRegion($region)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setEmail($email)
            ->setPhone($phone)
            ->setComments($comments);
    }
    /**
     * Get attentionTo value
     * @return string|null
     */
    public function getAttentionTo()
    {
        return $this->attentionTo;
    }
    /**
     * Set attentionTo value
     * @param string $attentionTo
     * @return \StructType\ContactDetails
     */
    public function setAttentionTo($attentionTo = null)
    {
        // validation for constraint: string
        if (!is_null($attentionTo) && !is_string($attentionTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attentionTo, true), gettype($attentionTo)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($attentionTo) && mb_strlen($attentionTo) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($attentionTo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($attentionTo) && mb_strlen($attentionTo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($attentionTo)), __LINE__);
        }
        $this->attentionTo = $attentionTo;
        return $this;
    }
    /**
     * Get companyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->companyName;
    }
    /**
     * Set companyName value
     * @param string $companyName
     * @return \StructType\ContactDetails
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($companyName) && mb_strlen($companyName) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($companyName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyName) && mb_strlen($companyName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyName)), __LINE__);
        }
        $this->companyName = $companyName;
        return $this;
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \StructType\ContactDetails
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($address1) && mb_strlen($address1) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($address1)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($address1) && mb_strlen($address1) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \StructType\ContactDetails
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($address2) && mb_strlen($address2) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($address2)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($address2) && mb_strlen($address2) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \StructType\ContactDetails
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($address3) && mb_strlen($address3) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($address3)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($address3) && mb_strlen($address3) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\ContactDetails
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($city) && mb_strlen($city) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($city) && mb_strlen($city) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\ContactDetails
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($region) && mb_strlen($region) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\ContactDetails
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postalCode) && mb_strlen($postalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\ContactDetails
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($country) && mb_strlen($country) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($country)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($country) && mb_strlen($country) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ContactDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($email) && mb_strlen($email) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email) && mb_strlen($email) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\ContactDetails
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($phone) && mb_strlen($phone) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($phone) && mb_strlen($phone) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->comments;
    }
    /**
     * Set comments value
     * @param string $comments
     * @return \StructType\ContactDetails
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->comments = $comments;
        return $this;
    }
}
