<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configuration StructType
 * Meta information extracted from the WSDL
 * - documentation: An object containing line item configuration data
 * @subpackage Structs
 */
class Configuration extends AbstractStructBase
{
    /**
     * The ChargeArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\ChargeArray
     */
    public $ChargeArray;
    /**
     * The LocationArray
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \ArrayType\LocationArray
     */
    public $LocationArray;
    /**
     * The referenceNumberType
     * Meta information extracted from the WSDL
     * - documentation: The type of the prior order reference; values are enumerated
     * - base: ns2:ReferenceNumberTypeType
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceNumberType;
    /**
     * The referenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The previous order number that this purchase order is referencing
     * - base: xsd:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $referenceNumber;
    /**
     * The preProductionProof
     * Meta information extracted from the WSDL
     * - documentation: Indicates that this line item is for a preproduction proof
     * @var bool
     */
    public $preProductionProof;
    /**
     * Constructor method for Configuration
     * @uses Configuration::setChargeArray()
     * @uses Configuration::setLocationArray()
     * @uses Configuration::setReferenceNumberType()
     * @uses Configuration::setReferenceNumber()
     * @uses Configuration::setPreProductionProof()
     * @param \ArrayType\ChargeArray $chargeArray
     * @param \ArrayType\LocationArray $locationArray
     * @param string $referenceNumberType
     * @param string $referenceNumber
     * @param bool $preProductionProof
     */
    public function __construct(\ArrayType\ChargeArray $chargeArray = null, \ArrayType\LocationArray $locationArray = null, $referenceNumberType = null, $referenceNumber = null, $preProductionProof = null)
    {
        $this
            ->setChargeArray($chargeArray)
            ->setLocationArray($locationArray)
            ->setReferenceNumberType($referenceNumberType)
            ->setReferenceNumber($referenceNumber)
            ->setPreProductionProof($preProductionProof);
    }
    /**
     * Get ChargeArray value
     * @return \ArrayType\ChargeArray|null
     */
    public function getChargeArray()
    {
        return $this->ChargeArray;
    }
    /**
     * Set ChargeArray value
     * @param \ArrayType\ChargeArray $chargeArray
     * @return \StructType\Configuration
     */
    public function setChargeArray(\ArrayType\ChargeArray $chargeArray = null)
    {
        $this->ChargeArray = $chargeArray;
        return $this;
    }
    /**
     * Get LocationArray value
     * @return \ArrayType\LocationArray|null
     */
    public function getLocationArray()
    {
        return $this->LocationArray;
    }
    /**
     * Set LocationArray value
     * @param \ArrayType\LocationArray $locationArray
     * @return \StructType\Configuration
     */
    public function setLocationArray(\ArrayType\LocationArray $locationArray = null)
    {
        $this->LocationArray = $locationArray;
        return $this;
    }
    /**
     * Get referenceNumberType value
     * @return string|null
     */
    public function getReferenceNumberType()
    {
        return $this->referenceNumberType;
    }
    /**
     * Set referenceNumberType value
     * @param string $referenceNumberType
     * @return \StructType\Configuration
     */
    public function setReferenceNumberType($referenceNumberType = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumberType) && !is_string($referenceNumberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumberType, true), gettype($referenceNumberType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($referenceNumberType) && mb_strlen($referenceNumberType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($referenceNumberType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceNumberType) && mb_strlen($referenceNumberType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceNumberType)), __LINE__);
        }
        $this->referenceNumberType = $referenceNumberType;
        return $this;
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\Configuration
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($referenceNumber) && mb_strlen($referenceNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($referenceNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($referenceNumber) && mb_strlen($referenceNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get preProductionProof value
     * @return bool|null
     */
    public function getPreProductionProof()
    {
        return $this->preProductionProof;
    }
    /**
     * Set preProductionProof value
     * @param bool $preProductionProof
     * @return \StructType\Configuration
     */
    public function setPreProductionProof($preProductionProof = null)
    {
        // validation for constraint: boolean
        if (!is_null($preProductionProof) && !is_bool($preProductionProof)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($preProductionProof, true), gettype($preProductionProof)), __LINE__);
        }
        $this->preProductionProof = $preProductionProof;
        return $this;
    }
}
