<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge StructType
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The chargeName
     * Meta information extracted from the WSDL
     * - documentation: The Charge name
     * - base: xsd:token
     * - maxLength: 128
     * - minLength: 1
     * - minOccurs: 0
     * - ref: ns2:chargeName
     * @var string
     */
    public $chargeName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:description
     * @var string
     */
    public $description;
    /**
     * The extendedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:extendedPrice
     * @var float
     */
    public $extendedPrice;
    /**
     * The unitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns2:unitPrice
     * @var float
     */
    public $unitPrice;
    /**
     * The chargeId
     * Meta information extracted from the WSDL
     * - ref: ns2:chargeId
     * @var int
     */
    public $chargeId;
    /**
     * The chargeType
     * Meta information extracted from the WSDL
     * - documentation: The charge name
     * - base: ns2:ChargeTypeType
     * - maxLength: 64
     * - minLength: 1
     * - ref: ns2:chargeType
     * @var string
     */
    public $chargeType;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - ref: ns2:Quantity
     * @var \StructType\Quantity
     */
    public $Quantity;
    /**
     * Constructor method for Charge
     * @uses Charge::setChargeName()
     * @uses Charge::setDescription()
     * @uses Charge::setExtendedPrice()
     * @uses Charge::setUnitPrice()
     * @uses Charge::setChargeId()
     * @uses Charge::setChargeType()
     * @uses Charge::setQuantity()
     * @param string $chargeName
     * @param string $description
     * @param float $extendedPrice
     * @param float $unitPrice
     * @param int $chargeId
     * @param string $chargeType
     * @param \StructType\Quantity $quantity
     */
    public function __construct($chargeName = null, $description = null, $extendedPrice = null, $unitPrice = null, $chargeId = null, $chargeType = null, \StructType\Quantity $quantity = null)
    {
        $this
            ->setChargeName($chargeName)
            ->setDescription($description)
            ->setExtendedPrice($extendedPrice)
            ->setUnitPrice($unitPrice)
            ->setChargeId($chargeId)
            ->setChargeType($chargeType)
            ->setQuantity($quantity);
    }
    /**
     * Get chargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->chargeName;
    }
    /**
     * Set chargeName value
     * @param string $chargeName
     * @return \StructType\Charge
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeName, true), gettype($chargeName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($chargeName) && mb_strlen($chargeName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($chargeName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeName) && mb_strlen($chargeName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeName)), __LINE__);
        }
        $this->chargeName = $chargeName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Charge
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get extendedPrice value
     * @return float|null
     */
    public function getExtendedPrice()
    {
        return $this->extendedPrice;
    }
    /**
     * Set extendedPrice value
     * @param float $extendedPrice
     * @return \StructType\Charge
     */
    public function setExtendedPrice($extendedPrice = null)
    {
        // validation for constraint: float
        if (!is_null($extendedPrice) && !(is_float($extendedPrice) || is_numeric($extendedPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extendedPrice, true), gettype($extendedPrice)), __LINE__);
        }
        $this->extendedPrice = $extendedPrice;
        return $this;
    }
    /**
     * Get unitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->unitPrice;
    }
    /**
     * Set unitPrice value
     * @param float $unitPrice
     * @return \StructType\Charge
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        $this->unitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get chargeId value
     * @return int|null
     */
    public function getChargeId()
    {
        return $this->chargeId;
    }
    /**
     * Set chargeId value
     * @param int $chargeId
     * @return \StructType\Charge
     */
    public function setChargeId($chargeId = null)
    {
        // validation for constraint: int
        if (!is_null($chargeId) && !(is_int($chargeId) || ctype_digit($chargeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($chargeId, true), gettype($chargeId)), __LINE__);
        }
        $this->chargeId = $chargeId;
        return $this;
    }
    /**
     * Get chargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param string $chargeType
     * @return \StructType\Charge
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeType, true), gettype($chargeType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($chargeType) && mb_strlen($chargeType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($chargeType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($chargeType) && mb_strlen($chargeType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($chargeType)), __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Quantity|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Quantity $quantity
     * @return \StructType\Charge
     */
    public function setQuantity(\StructType\Quantity $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
}
