<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtworkFile StructType
 * @subpackage Structs
 */
class ArtworkFile extends AbstractStructBase
{
    /**
     * The artworkType
     * Meta information extracted from the WSDL
     * - documentation: The purpose of the artwork file; values are enumerated
     * - base: ns2:ArtworkType
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $artworkType;
    /**
     * The fileLocation
     * Meta information extracted from the WSDL
     * - documentation: The exact path/location to the artwork
     * - base: xsd:string
     * - maxLength: 1024
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $fileLocation;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - documentation: The file name and extension only of the artwork
     * - base: xsd:string
     * - maxLength: 256
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $fileName;
    /**
     * The transportMechanism
     * Meta information extracted from the WSDL
     * - documentation: The mechanism that will be used to transport the artwork; values are enumerated
     * - base: ns2:TransportMechanismType
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $transportMechanism;
    /**
     * Constructor method for ArtworkFile
     * @uses ArtworkFile::setArtworkType()
     * @uses ArtworkFile::setFileLocation()
     * @uses ArtworkFile::setFileName()
     * @uses ArtworkFile::setTransportMechanism()
     * @param string $artworkType
     * @param string $fileLocation
     * @param string $fileName
     * @param string $transportMechanism
     */
    public function __construct($artworkType = null, $fileLocation = null, $fileName = null, $transportMechanism = null)
    {
        $this
            ->setArtworkType($artworkType)
            ->setFileLocation($fileLocation)
            ->setFileName($fileName)
            ->setTransportMechanism($transportMechanism);
    }
    /**
     * Get artworkType value
     * @return string
     */
    public function getArtworkType()
    {
        return $this->artworkType;
    }
    /**
     * Set artworkType value
     * @param string $artworkType
     * @return \StructType\ArtworkFile
     */
    public function setArtworkType($artworkType = null)
    {
        // validation for constraint: string
        if (!is_null($artworkType) && !is_string($artworkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artworkType, true), gettype($artworkType)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($artworkType) && mb_strlen($artworkType) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($artworkType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artworkType) && mb_strlen($artworkType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artworkType)), __LINE__);
        }
        $this->artworkType = $artworkType;
        return $this;
    }
    /**
     * Get fileLocation value
     * @return string
     */
    public function getFileLocation()
    {
        return $this->fileLocation;
    }
    /**
     * Set fileLocation value
     * @param string $fileLocation
     * @return \StructType\ArtworkFile
     */
    public function setFileLocation($fileLocation = null)
    {
        // validation for constraint: string
        if (!is_null($fileLocation) && !is_string($fileLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileLocation, true), gettype($fileLocation)), __LINE__);
        }
        // validation for constraint: maxLength(1024)
        if (!is_null($fileLocation) && mb_strlen($fileLocation) > 1024) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1024', mb_strlen($fileLocation)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fileLocation) && mb_strlen($fileLocation) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fileLocation)), __LINE__);
        }
        $this->fileLocation = $fileLocation;
        return $this;
    }
    /**
     * Get fileName value
     * @return string
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\ArtworkFile
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($fileName) && mb_strlen($fileName) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($fileName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fileName) && mb_strlen($fileName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get transportMechanism value
     * @return string
     */
    public function getTransportMechanism()
    {
        return $this->transportMechanism;
    }
    /**
     * Set transportMechanism value
     * @param string $transportMechanism
     * @return \StructType\ArtworkFile
     */
    public function setTransportMechanism($transportMechanism = null)
    {
        // validation for constraint: string
        if (!is_null($transportMechanism) && !is_string($transportMechanism)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportMechanism, true), gettype($transportMechanism)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($transportMechanism) && mb_strlen($transportMechanism) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($transportMechanism)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($transportMechanism) && mb_strlen($transportMechanism) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($transportMechanism)), __LINE__);
        }
        $this->transportMechanism = $transportMechanism;
        return $this;
    }
}
